package cn.ibizlab.core.sample.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import com.baomidou.mybatisplus.extension.service.IService;
import com.baomidou.dynamic.datasource.annotation.DS;
import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.security.SpringContextHolder;
import cn.ibizlab.core.sample.domain.IBIZOrderType;
import cn.ibizlab.core.sample.filter.IBIZOrderTypeSearchContext;

public interface IBIZOrderTypeService extends IService<IBIZOrderType> {

    default IBIZOrderTypeService getSelf() {
        return SpringContextHolder.getBean(this.getClass());
    }

    IBIZOrderType get(IBIZOrderType et);
    default IBIZOrderType get(String key) {
        IBIZOrderType et = new IBIZOrderType();
        et.setIbizOrderTypeId(key);
        return getSelf().get(et);
    }
    default List<IBIZOrderType> getByIds(Collection<String> ids) {
        List<IBIZOrderType> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZOrderType et = new IBIZOrderType();
            et.setIbizOrderTypeId(key);
            entities.add(et);
        });
        return getSelf().getByEntities(entities);
    }
    List<IBIZOrderType> getByEntities(List<IBIZOrderType> entities);

    IBIZOrderType getDraft(IBIZOrderType et);

    Integer checkKey(IBIZOrderType et);

    boolean create(IBIZOrderType et);
    boolean createBatch(List<IBIZOrderType> list);

    boolean update(IBIZOrderType et);
    boolean updateBatch(List<IBIZOrderType> list);

    boolean save(IBIZOrderType et);
    boolean saveBatch(List<IBIZOrderType> list);

    default boolean remove(String key) {
        IBIZOrderType et = new IBIZOrderType();
        et.setIbizOrderTypeId(key);
        return getSelf().remove(et);
    }
    default boolean remove(List<String> key) {
        return removeBatch(key);
    }
    boolean remove(IBIZOrderType et);

    default boolean removeBatch(Collection<String> ids) {
        List<IBIZOrderType> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZOrderType et = new IBIZOrderType();
            et.setIbizOrderTypeId(key);
            entities.add(et);
        });
        return getSelf().removeByEntities(entities);
    }

    boolean removeByEntities(List<IBIZOrderType> entities);

    default IBIZOrderType resetCodeList(IBIZOrderType dto) {
        return dto;
    }

    Page<IBIZOrderType> searchDefault(IBIZOrderTypeSearchContext context);
    List<IBIZOrderType> listDefault(IBIZOrderTypeSearchContext context);

}