package cn.ibizlab.core.sample.mapping;

import org.mapstruct.*;
import cn.ibizlab.core.sample.domain.IBIZStorage;
import cn.ibizlab.core.sample.domain.IBIZHardware;
import java.util.List;

@Mapper(componentModel = "spring", uses = {})
public interface IBIZStorageInheritMapping {

    @Mappings({
            @Mapping(target ="focusNull",ignore = true),
            @Mapping(source ="ibizStorageId",target = "ibizHardwareId"),
            @Mapping(source ="ibizStorageName",target = "ibizHardwareName"),
    })
    IBIZHardware toIbizHardware(IBIZStorage ibizStorage);

    @Mappings({
            @Mapping(target ="focusNull",ignore = true),
            @Mapping(source ="ibizHardwareId",target = "ibizStorageId"),
            @Mapping(source ="ibizHardwareName",target = "ibizStorageName"),
    })
    IBIZStorage toIbizStorage(IBIZHardware ibizHardware);

    List<IBIZHardware> toIbizHardware(List<IBIZStorage> list);

    List<IBIZStorage> toIbizStorage(List<IBIZHardware> list);

}
