package cn.ibizlab.core.sample.filter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;
import lombok.extern.slf4j.Slf4j;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import cn.ibizlab.util.filter.QueryWrapperContext;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.ibizlab.core.sample.domain.IBIZCustomer;
/**
 * 关系型数据实体[IBIZCustomer] 查询条件对象
 */
@Slf4j
@Getter
@Setter
@NoArgsConstructor
@ApiModel("客户")
public class IBIZCustomerSearchContext extends QueryWrapperContext<IBIZCustomer> {

    @JsonProperty("n_ibizcustomerid_eq")
    @JSONField(name = "n_ibizcustomerid_eq")
    @ApiModelProperty("客户标识EQ")
	private String ibizCustomerIdEQ;
	public IBIZCustomerSearchContext setIbizCustomerIdEQ(String ibizCustomerIdEQ) {
        this.ibizCustomerIdEQ = ibizCustomerIdEQ;
        if(!ObjectUtils.isEmpty(this.ibizCustomerIdEQ)){
            this.getSearchCond().eq("ibizcustomerid", ibizCustomerIdEQ);
        }
        return this;
    }
                    
    @JsonProperty("n_ibizcustomername_like")
    @JSONField(name = "n_ibizcustomername_like")
    @ApiModelProperty("客户名称LIKE")
	private String ibizCustomerNameLIKE;
	public IBIZCustomerSearchContext setIbizCustomerNameLIKE(String ibizCustomerNameLIKE) {
        this.ibizCustomerNameLIKE = ibizCustomerNameLIKE;
        if(!ObjectUtils.isEmpty(this.ibizCustomerNameLIKE)){
            this.getSearchCond().like("ibizcustomername", ibizCustomerNameLIKE);
        }
        return this;
    }
                    

    /**
	 * 启用快速搜索
	 */
	public void setQuery(String query)
	{
		this.query=query;
		if(!StringUtils.isEmpty(query)){
            this.getSearchCond().and( wrapper ->
                     wrapper.like("ibizcustomername", query)
            );
		}
	}
}