package cn.ibizlab.core.sample.filter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;
import lombok.extern.slf4j.Slf4j;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import cn.ibizlab.util.filter.QueryWrapperContext;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.ibizlab.core.sample.domain.IBIZAccount;
/**
 * 关系型数据实体[IBIZAccount] 查询条件对象
 */
@Slf4j
@Getter
@Setter
@NoArgsConstructor
@ApiModel("账户")
public class IBIZAccountSearchContext extends QueryWrapperContext<IBIZAccount> {

    @JsonProperty("n_ibizaccountname_like")
    @JSONField(name = "n_ibizaccountname_like")
    @ApiModelProperty("账户名称LIKE")
	private String ibizAccountNameLIKE;
	public IBIZAccountSearchContext setIbizAccountNameLIKE(String ibizAccountNameLIKE) {
        this.ibizAccountNameLIKE = ibizAccountNameLIKE;
        if(!ObjectUtils.isEmpty(this.ibizAccountNameLIKE)){
            this.getSearchCond().like("ibizaccountname", ibizAccountNameLIKE);
        }
        return this;
    }
                    
    @JsonProperty("n_ibizaccountid_eq")
    @JSONField(name = "n_ibizaccountid_eq")
    @ApiModelProperty("账户标识EQ")
	private String ibizAccountIdEQ;
	public IBIZAccountSearchContext setIbizAccountIdEQ(String ibizAccountIdEQ) {
        this.ibizAccountIdEQ = ibizAccountIdEQ;
        if(!ObjectUtils.isEmpty(this.ibizAccountIdEQ)){
            this.getSearchCond().eq("ibizaccountid", ibizAccountIdEQ);
        }
        return this;
    }
                    

    /**
	 * 启用快速搜索
	 */
	public void setQuery(String query)
	{
		this.query=query;
		if(!StringUtils.isEmpty(query)){
            this.getSearchCond().and( wrapper ->
                     wrapper.like("ibizaccountname", query)
            );
		}
	}
}