package cn.ibizlab.core.sample.domain;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.math.BigInteger;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import org.springframework.util.ObjectUtils;
import org.springframework.util.DigestUtils;
import org.springframework.util.Assert;
import cn.ibizlab.util.domain.EntityBase;
import cn.ibizlab.util.annotation.DEField;
import cn.ibizlab.util.enums.DEPredefinedFieldType;
import cn.ibizlab.util.enums.DEFieldDefaultValueType;
import cn.ibizlab.util.helper.DataObject;
import cn.ibizlab.util.annotation.Audit;
import cn.ibizlab.util.enums.DupCheck;
import cn.ibizlab.util.domain.EntityMP;
import java.io.Serializable;
import lombok.*;
import lombok.experimental.Accessors;
import org.springframework.data.annotation.Transient;
import org.springframework.data.annotation.Id;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.baomidou.mybatisplus.annotation.*;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;

@Getter
@Setter
@NoArgsConstructor
@JsonIgnoreProperties(value = "handler")
@TableName(value = "T_IBIZUNIPRODUCT", resultMap = "IBIZUNIProductResultMap")
@ApiModel(value = "IBIZUNIPRODUCT", description = "统一产品（索引主实体）")
public class IBIZUNIProduct extends EntityMP implements Serializable
{

    /**
     * 单价
     */
    @TableField(value = "unitprice")
    @DEField(name = "unitprice")
    @JsonProperty("unitprice")
    @JSONField(name = "unitprice")
    @ApiModelProperty(value = "unitprice", notes = "单价")
    private BigDecimal unitPrice;

    /**
     * 产品名称
     */
    @TableField(value = "ibizuniproductname")
    @DEField(name = "ibizuniproductname")
    @JsonProperty("ibizuniproductname")
    @JSONField(name = "ibizuniproductname")
    @ApiModelProperty(value = "ibizuniproductname", notes = "产品名称")
    private String ibizuniProductName;

    /**
     * 更新时间
     */
    @TableField(value = "updatedate")
    @DEField(name = "updatedate" , preType = DEPredefinedFieldType.UPDATEDATE)
    @JsonProperty("updatedate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatedate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "updatedate", notes = "更新时间")
    private Timestamp updateDate;

    /**
     * 单位
     */
    @TableField(value = "unit")
    @DEField(name = "unit")
    @JsonProperty("unit")
    @JSONField(name = "unit")
    @ApiModelProperty(value = "unit", notes = "单位")
    private String unit;

    /**
     * 分组类型
     */
    @TableField(value = "ibizuniproducttype")
    @DEField(name = "ibizuniproducttype" , dict = "UNIPRODUCTTYPE")
    @JsonProperty("ibizuniproducttype")
    @JSONField(name = "ibizuniproducttype")
    @ApiModelProperty(value = "ibizuniproducttype", notes = "分组类型")
    private String ibizuniProductType;

    /**
     * 更新人
     */
    @TableField(value = "updateman")
    @DEField(name = "updateman" , preType = DEPredefinedFieldType.UPDATEMAN , dict = "SysOperator")
    @JsonProperty("updateman")
    @JSONField(name = "updateman")
    @ApiModelProperty(value = "updateman", notes = "更新人")
    private String updateMan;

    /**
     * 建立时间
     */
    @TableField(value = "createdate" , fill = FieldFill.INSERT)
    @DEField(name = "createdate" , preType = DEPredefinedFieldType.CREATEDATE)
    @JsonProperty("createdate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createdate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "createdate", notes = "建立时间")
    private Timestamp createDate;

    /**
     * 建立人
     */
    @TableField(value = "createman" , fill = FieldFill.INSERT)
    @DEField(name = "createman" , preType = DEPredefinedFieldType.CREATEMAN , dict = "SysOperator")
    @JsonProperty("createman")
    @JSONField(name = "createman")
    @ApiModelProperty(value = "createman", notes = "建立人")
    private String createMan;

    /**
     * 统一产品标识
     */
    @Id
    @TableId(value = "ibizuniproductid" , type = IdType.ASSIGN_UUID)
    @DEField(name = "ibizuniproductid" , isKeyField = true)
    @JsonProperty("ibizuniproductid")
    @JSONField(name = "ibizuniproductid")
    @ApiModelProperty(value = "ibizuniproductid", notes = "统一产品标识")
    private String ibizuniProductId;




    /**
     * 设置 [单价]
     */
    public void setUnitPrice(BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
        this.modify("unitprice", unitPrice);
    }

    /**
     * 设置 [产品名称]
     */
    public void setIbizuniProductName(String ibizuniProductName) {
        this.ibizuniProductName = ibizuniProductName;
        this.modify("ibizuniproductname", ibizuniProductName);
    }


    /**
     * 设置 [单位]
     */
    public void setUnit(String unit) {
        this.unit = unit;
        this.modify("unit", unit);
    }

    /**
     * 设置 [分组类型]
     */
    public void setIbizuniProductType(String ibizuniProductType) {
        this.ibizuniProductType = ibizuniProductType;
        this.modify("ibizuniproducttype", ibizuniProductType);
    }







    

    /**
     * 复制当前对象数据到目标对象(粘贴重置)
     * @param targetEntity 目标数据对象
     * @param bIncEmpty  是否包括空值
     * @param <T>
     * @return
     */
    @Override
    public <T> T copyTo(T targetEntity, boolean bIncEmpty) {
        this.reset("ibizuniproductid");        
        return super.copyTo(targetEntity, bIncEmpty);
    }    
}