package cn.ibizlab.core.sample.domain;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.math.BigInteger;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import org.springframework.util.ObjectUtils;
import org.springframework.util.DigestUtils;
import org.springframework.util.Assert;
import cn.ibizlab.util.domain.EntityBase;
import cn.ibizlab.util.annotation.DEField;
import cn.ibizlab.util.enums.DEPredefinedFieldType;
import cn.ibizlab.util.enums.DEFieldDefaultValueType;
import cn.ibizlab.util.helper.DataObject;
import cn.ibizlab.util.annotation.Audit;
import cn.ibizlab.util.enums.DupCheck;
import cn.ibizlab.util.domain.EntityMP;
import java.io.Serializable;
import lombok.*;
import lombok.experimental.Accessors;
import org.springframework.data.annotation.Transient;
import org.springframework.data.annotation.Id;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.baomidou.mybatisplus.annotation.*;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import cn.ibizlab.core.sample.domain.IBIZSample0006;

@Getter
@Setter
@NoArgsConstructor
@JsonIgnoreProperties(value = "handler")
@TableName(value = "T_IBIZSAMPLE0007", resultMap = "IBIZSample0007ResultMap")
@ApiModel(value = "IBIZSAMPLE0007", description = "嵌套流程（子）")
public class IBIZSample0007 extends EntityMP implements Serializable
{

    /**
     * 更新时间
     */
    @TableField(value = "updatedate")
    @DEField(name = "updatedate" , preType = DEPredefinedFieldType.UPDATEDATE)
    @JsonProperty("updatedate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatedate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "updatedate", notes = "更新时间")
    private Timestamp updateDate;

    /**
     * 嵌套流程（子）标识
     */
    @Id
    @TableId(value = "ibizsample0007id" , type = IdType.ASSIGN_UUID)
    @DEField(name = "ibizsample0007id" , isKeyField = true)
    @JsonProperty("ibizsample0007id")
    @JSONField(name = "ibizsample0007id")
    @ApiModelProperty(value = "ibizsample0007id", notes = "嵌套流程（子）标识")
    private String ibizSample0007Id;

    /**
     * 工作流版本
     */
    @TableField(value = "wfversion")
    @DEField(name = "wfversion")
    @JsonProperty("wfversion")
    @JSONField(name = "wfversion")
    @ApiModelProperty(value = "wfversion", notes = "工作流版本")
    private String wfVersion;

    /**
     * 公文名称
     */
    @TableField(value = "ibizsample0007name")
    @DEField(name = "ibizsample0007name")
    @JsonProperty("ibizsample0007name")
    @JSONField(name = "ibizsample0007name")
    @ApiModelProperty(value = "ibizsample0007name", notes = "公文名称")
    private String ibizSample0007Name;

    /**
     * 工作流步骤
     */
    @TableField(value = "wfstate")
    @DEField(name = "wfstate" , dict = "WFStates")
    @JsonProperty("wfstate")
    @JSONField(name = "wfstate")
    @ApiModelProperty(value = "wfstate", notes = "工作流步骤")
    private Integer wfState;

    /**
     * 业务状态
     */
    @TableField(value = "ywstate")
    @DEField(name = "ywstate")
    @JsonProperty("ywstate")
    @JSONField(name = "ywstate")
    @ApiModelProperty(value = "ywstate", notes = "业务状态")
    private String ywState;

    /**
     * 更新人
     */
    @TableField(value = "updateman")
    @DEField(name = "updateman" , preType = DEPredefinedFieldType.UPDATEMAN , dict = "SysOperator")
    @JsonProperty("updateman")
    @JSONField(name = "updateman")
    @ApiModelProperty(value = "updateman", notes = "更新人")
    private String updateMan;

    /**
     * 工作流实例
     */
    @TableField(value = "wfinstanceid")
    @DEField(name = "wfinstanceid")
    @JsonProperty("wfinstanceid")
    @JSONField(name = "wfinstanceid")
    @ApiModelProperty(value = "wfinstanceid", notes = "工作流实例")
    private String wfInstanceId;

    /**
     * 建立时间
     */
    @TableField(value = "createdate" , fill = FieldFill.INSERT)
    @DEField(name = "createdate" , preType = DEPredefinedFieldType.CREATEDATE)
    @JsonProperty("createdate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createdate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "createdate", notes = "建立时间")
    private Timestamp createDate;

    /**
     * 会签步骤
     */
    @TableField(value = "wfstep")
    @DEField(name = "wfstep" , dict = "SNSTEP")
    @JsonProperty("wfstep")
    @JSONField(name = "wfstep")
    @ApiModelProperty(value = "wfstep", notes = "会签步骤")
    private String wfStep;

    /**
     * 建立人
     */
    @TableField(value = "createman" , fill = FieldFill.INSERT)
    @DEField(name = "createman" , preType = DEPredefinedFieldType.CREATEMAN , dict = "SysOperator")
    @JsonProperty("createman")
    @JSONField(name = "createman")
    @ApiModelProperty(value = "createman", notes = "建立人")
    private String createMan;

    /**
     * 公文编号
     */
    @TableField(value = "dnum" , exist = false)
    @DEField(name = "dnum")
    @JsonProperty("dnum")
    @JSONField(name = "dnum")
    @ApiModelProperty(value = "dnum", notes = "公文编号")
    private String dNum;

    /**
     * 公文时间
     */
    @TableField(value = "ddate" , exist = false)
    @DEField(name = "ddate")
    @JsonProperty("ddate")
    @JsonFormat(pattern = "yyyy-MM-dd", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "ddate" , format = "yyyy-MM-dd")
    @ApiModelProperty(value = "ddate", notes = "公文时间")
    private Timestamp dDate;

    /**
     * 正文
     */
    @TableField(value = "dtext" , exist = false)
    @DEField(name = "dtext")
    @JsonProperty("dtext")
    @JSONField(name = "dtext")
    @ApiModelProperty(value = "dtext", notes = "正文")
    private String dText;

    /**
     * 嵌套流程（主）名称
     */
    @TableField(value = "ibizsample0006name" , exist = false)
    @DEField(name = "ibizsample0006name")
    @JsonProperty("ibizsample0006name")
    @JSONField(name = "ibizsample0006name")
    @ApiModelProperty(value = "ibizsample0006name", notes = "嵌套流程（主）名称")
    private String ibizSample0006Name;

    /**
     * 嵌套流程（主）标识
     */
    @TableField(value = "ibizsample0006id")
    @DEField(name = "ibizsample0006id")
    @JsonProperty("ibizsample0006id")
    @JSONField(name = "ibizsample0006id")
    @ApiModelProperty(value = "ibizsample0006id", notes = "嵌套流程（主）标识")
    private String ibizSample0006Id;


    /**
     * 嵌套流程（主）
     */
    @JsonIgnore
    @JSONField(serialize = false)
    @TableField(exist = false)
    @ApiModelProperty(value = "ibizsample0006", notes = "")
    private IBIZSample0006 ibizsample0006;




    /**
     * 设置 [工作流版本]
     */
    public void setWfVersion(String wfVersion) {
        this.wfVersion = wfVersion;
        this.modify("wfversion", wfVersion);
    }

    /**
     * 设置 [公文名称]
     */
    public void setIbizSample0007Name(String ibizSample0007Name) {
        this.ibizSample0007Name = ibizSample0007Name;
        this.modify("ibizsample0007name", ibizSample0007Name);
    }

    /**
     * 设置 [工作流步骤]
     */
    public void setWfState(Integer wfState) {
        this.wfState = wfState;
        this.modify("wfstate", wfState);
    }

    /**
     * 设置 [业务状态]
     */
    public void setYwState(String ywState) {
        this.ywState = ywState;
        this.modify("ywstate", ywState);
    }


    /**
     * 设置 [工作流实例]
     */
    public void setWfInstanceId(String wfInstanceId) {
        this.wfInstanceId = wfInstanceId;
        this.modify("wfinstanceid", wfInstanceId);
    }


    /**
     * 设置 [会签步骤]
     */
    public void setWfStep(String wfStep) {
        this.wfStep = wfStep;
        this.modify("wfstep", wfStep);
    }


    /**
     * 设置 [公文编号]
     */
    public void setDNum(String dNum) {
        this.dNum = dNum;
        this.modify("dnum", dNum);
    }

    /**
     * 设置 [公文时间]
     */
    public void setDDate(Timestamp dDate) {
        this.dDate = dDate;
        this.modify("ddate", dDate);
    }

    /**
     * 设置 [正文]
     */
    public void setDText(String dText) {
        this.dText = dText;
        this.modify("dtext", dText);
    }

    /**
     * 设置 [嵌套流程（主）名称]
     */
    public void setIbizSample0006Name(String ibizSample0006Name) {
        this.ibizSample0006Name = ibizSample0006Name;
        this.modify("ibizsample0006name", ibizSample0006Name);
    }

    /**
     * 设置 [嵌套流程（主）标识]
     */
    public void setIbizSample0006Id(String ibizSample0006Id) {
        this.ibizSample0006Id = ibizSample0006Id;
        this.modify("ibizsample0006id", ibizSample0006Id);
    }



    

    /**
     * 复制当前对象数据到目标对象(粘贴重置)
     * @param targetEntity 目标数据对象
     * @param bIncEmpty  是否包括空值
     * @param <T>
     * @return
     */
    @Override
    public <T> T copyTo(T targetEntity, boolean bIncEmpty) {
        this.reset("ibizsample0007id");        
        return super.copyTo(targetEntity, bIncEmpty);
    }    
}