package cn.ibizlab.core.sample.domain;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.math.BigInteger;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import org.springframework.util.ObjectUtils;
import org.springframework.util.DigestUtils;
import org.springframework.util.Assert;
import cn.ibizlab.util.domain.EntityBase;
import cn.ibizlab.util.annotation.DEField;
import cn.ibizlab.util.enums.DEPredefinedFieldType;
import cn.ibizlab.util.enums.DEFieldDefaultValueType;
import cn.ibizlab.util.helper.DataObject;
import cn.ibizlab.util.annotation.Audit;
import cn.ibizlab.util.enums.DupCheck;
import cn.ibizlab.util.domain.EntityMP;
import java.io.Serializable;
import lombok.*;
import lombok.experimental.Accessors;
import org.springframework.data.annotation.Transient;
import org.springframework.data.annotation.Id;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.baomidou.mybatisplus.annotation.*;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;

@Getter
@Setter
@NoArgsConstructor
@JsonIgnoreProperties(value = "handler")
@TableName(value = "T_IBIZSAMPLE0003", resultMap = "IBIZSample0003ResultMap")
@ApiModel(value = "IBIZSAMPLE0003", description = "示例实体03")
public class IBIZSample0003 extends EntityMP implements Serializable
{

    /**
     * 名称
     */
    @TableField(value = "ibizsample0003name")
    @DEField(name = "ibizsample0003name")
    @JsonProperty("ibizsample0003name")
    @JSONField(name = "ibizsample0003name")
    @ApiModelProperty(value = "ibizsample0003name", notes = "名称")
    private String ibizsample0003Name;

    /**
     * 备注
     */
    @TableField(value = "memo")
    @DEField(name = "memo")
    @JsonProperty("memo")
    @JSONField(name = "memo")
    @ApiModelProperty(value = "memo", notes = "备注")
    private String memo;

    /**
     * 更新时间
     */
    @TableField(value = "updatedate")
    @DEField(name = "updatedate" , preType = DEPredefinedFieldType.UPDATEDATE)
    @JsonProperty("updatedate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatedate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "updatedate", notes = "更新时间")
    private Timestamp updateDate;

    /**
     * FIELD01
     */
    @TableField(value = "field01")
    @DEField(name = "field01")
    @JsonProperty("field01")
    @JSONField(name = "field01")
    @ApiModelProperty(value = "field01", notes = "FIELD01")
    private String field01;

    /**
     * 建立时间
     */
    @TableField(value = "createdate" , fill = FieldFill.INSERT)
    @DEField(name = "createdate" , preType = DEPredefinedFieldType.CREATEDATE)
    @JsonProperty("createdate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createdate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "createdate", notes = "建立时间")
    private Timestamp createDate;

    /**
     * 更新人
     */
    @TableField(value = "updateman")
    @DEField(name = "updateman" , preType = DEPredefinedFieldType.UPDATEMAN , dict = "SysOperator")
    @JsonProperty("updateman")
    @JSONField(name = "updateman")
    @ApiModelProperty(value = "updateman", notes = "更新人")
    private String updateMan;

    /**
     * IBIZSAMPLE0003标识
     */
    @Id
    @TableId(value = "ibizsample0003id" , type = IdType.ASSIGN_UUID)
    @DEField(name = "ibizsample0003id" , isKeyField = true)
    @JsonProperty("ibizsample0003id")
    @JSONField(name = "ibizsample0003id")
    @ApiModelProperty(value = "ibizsample0003id", notes = "IBIZSAMPLE0003标识")
    private String ibizsample0003Id;

    /**
     * 建立人
     */
    @TableField(value = "createman" , fill = FieldFill.INSERT)
    @DEField(name = "createman" , preType = DEPredefinedFieldType.CREATEMAN , dict = "SysOperator")
    @JsonProperty("createman")
    @JSONField(name = "createman")
    @ApiModelProperty(value = "createman", notes = "建立人")
    private String createMan;

    /**
     * 上级
     */
    @TableField(value = "pibizsample0003name" , exist = false)
    @DEField(name = "pibizsample0003name")
    @JsonProperty("pibizsample0003name")
    @JSONField(name = "pibizsample0003name")
    @ApiModelProperty(value = "pibizsample0003name", notes = "上级")
    private String pibizsample0003Name;

    /**
     * IBIZSAMPLE0003标识
     */
    @TableField(value = "pibizsample0003id")
    @DEField(name = "pibizsample0003id")
    @JsonProperty("pibizsample0003id")
    @JSONField(name = "pibizsample0003id")
    @ApiModelProperty(value = "pibizsample0003id", notes = "IBIZSAMPLE0003标识")
    private String pibizsample0003id;


    /**
     * 示例实体03
     */
    @JsonIgnore
    @JSONField(serialize = false)
    @TableField(exist = false)
    @ApiModelProperty(value = "pibizsample0003", notes = "")
    private IBIZSample0003 pibizsample0003;


    /**
     * 设置 [名称]
     */
    public void setIbizsample0003Name(String ibizsample0003Name) {
        this.ibizsample0003Name = ibizsample0003Name;
        this.modify("ibizsample0003name", ibizsample0003Name);
    }

    /**
     * 设置 [备注]
     */
    public void setMemo(String memo) {
        this.memo = memo;
        this.modify("memo", memo);
    }


    /**
     * 设置 [FIELD01]
     */
    public void setField01(String field01) {
        this.field01 = field01;
        this.modify("field01", field01);
    }





    /**
     * 设置 [上级]
     */
    public void setPibizsample0003Name(String pibizsample0003Name) {
        this.pibizsample0003Name = pibizsample0003Name;
        this.modify("pibizsample0003name", pibizsample0003Name);
    }

    /**
     * 设置 [IBIZSAMPLE0003标识]
     */
    public void setPibizsample0003id(String pibizsample0003id) {
        this.pibizsample0003id = pibizsample0003id;
        this.modify("pibizsample0003id", pibizsample0003id);
    }



    

    /**
     * 复制当前对象数据到目标对象(粘贴重置)
     * @param targetEntity 目标数据对象
     * @param bIncEmpty  是否包括空值
     * @param <T>
     * @return
     */
    @Override
    public <T> T copyTo(T targetEntity, boolean bIncEmpty) {
        this.reset("ibizsample0003id");        
        return super.copyTo(targetEntity, bIncEmpty);
    }    
}