package cn.ibizlab.core.sample.domain;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.math.BigInteger;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import org.springframework.util.ObjectUtils;
import org.springframework.util.DigestUtils;
import org.springframework.util.Assert;
import cn.ibizlab.util.domain.EntityBase;
import cn.ibizlab.util.annotation.DEField;
import cn.ibizlab.util.enums.DEPredefinedFieldType;
import cn.ibizlab.util.enums.DEFieldDefaultValueType;
import cn.ibizlab.util.helper.DataObject;
import cn.ibizlab.util.annotation.Audit;
import cn.ibizlab.util.enums.DupCheck;
import cn.ibizlab.util.domain.EntityMP;
import java.io.Serializable;
import lombok.*;
import lombok.experimental.Accessors;
import org.springframework.data.annotation.Transient;
import org.springframework.data.annotation.Id;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.baomidou.mybatisplus.annotation.*;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import cn.ibizlab.core.sample.domain.IBIZCustomer;

@Getter
@Setter
@NoArgsConstructor
@JsonIgnoreProperties(value = "handler")
@TableName(value = "T_IBIZORDER", resultMap = "IBIZOrderResultMap")
@ApiModel(value = "IBIZORDER", description = "订单")
public class IBIZOrder extends EntityMP implements Serializable
{

    /**
     * 图片
     */
    @TableField(value = "tp")
    @DEField(name = "tp")
    @JsonProperty("tp")
    @JSONField(name = "tp")
    @ApiModelProperty(value = "tp", notes = "图片")
    private String tp;

    /**
     * 订单结束时间
     */
    @TableField(value = "endtime")
    @DEField(name = "endtime")
    @JsonProperty("endtime")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "endtime" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "endtime", notes = "订单结束时间")
    private Timestamp endTime;

    /**
     * 工作流状态
     */
    @TableField(value = "wfstate")
    @DEField(name = "wfstate" , dict = "WFStates")
    @JsonProperty("wfstate")
    @JSONField(name = "wfstate")
    @ApiModelProperty(value = "wfstate", notes = "工作流状态")
    private Integer wfState;

    /**
     * 建立时间
     */
    @TableField(value = "createdate" , fill = FieldFill.INSERT)
    @DEField(name = "createdate" , preType = DEPredefinedFieldType.CREATEDATE)
    @JsonProperty("createdate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createdate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "createdate", notes = "建立时间")
    private Timestamp createDate;

    /**
     * 审批意见
     */
    @TableField(value = "opinion")
    @DEField(name = "opinion")
    @JsonProperty("opinion")
    @JSONField(name = "opinion")
    @ApiModelProperty(value = "opinion", notes = "审批意见")
    private String opinion;

    /**
     * 更新时间
     */
    @TableField(value = "updatedate")
    @DEField(name = "updatedate" , preType = DEPredefinedFieldType.UPDATEDATE)
    @JsonProperty("updatedate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatedate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "updatedate", notes = "更新时间")
    private Timestamp updateDate;

    /**
     * 订单类型
     */
    @TableField(value = "ordertype")
    @DEField(name = "ordertype" , dict = "ORDERTYPE")
    @JsonProperty("ordertype")
    @JSONField(name = "ordertype")
    @ApiModelProperty(value = "ordertype", notes = "订单类型")
    private String orderType;

    /**
     * 明细数
     */
    @TableField(value = "detailnum")
    @DEField(name = "detailnum")
    @JsonProperty("detailnum")
    @JSONField(name = "detailnum")
    @ApiModelProperty(value = "detailnum", notes = "明细数")
    private Integer detailNum;

    /**
     * 工作流实例
     */
    @TableField(value = "wfinstanceid")
    @DEField(name = "wfinstanceid")
    @JsonProperty("wfinstanceid")
    @JSONField(name = "wfinstanceid")
    @ApiModelProperty(value = "wfinstanceid", notes = "工作流实例")
    private String wfInstanceId;

    /**
     * 总计
     */
    @TableField(value = "amount")
    @DEField(name = "amount")
    @JsonProperty("amount")
    @JSONField(name = "amount")
    @ApiModelProperty(value = "amount", notes = "总计")
    private BigDecimal amount;

    /**
     * 订单编号
     */
    @TableField(value = "orderuid")
    @DEField(name = "orderuid" , dupCheck = DupCheck.ALL)
    @JsonProperty("orderuid")
    @JSONField(name = "orderuid")
    @ApiModelProperty(value = "orderuid", notes = "订单编号")
    private String orderUid;

    /**
     * 订单标识
     */
    @Id
    @TableId(value = "ibizorderid" , type = IdType.ASSIGN_UUID)
    @DEField(name = "ibizorderid" , isKeyField = true)
    @JsonProperty("ibizorderid")
    @JSONField(name = "ibizorderid")
    @ApiModelProperty(value = "ibizorderid", notes = "订单标识")
    private String ibizOrderId;

    /**
     * 订单状态
     */
    @TableField(value = "orderstate")
    @DEField(name = "orderstate" , defaultValue = "10" , dict = "ORDERSTATE")
    @JsonProperty("orderstate")
    @JSONField(name = "orderstate")
    @ApiModelProperty(value = "orderstate", notes = "订单状态")
    private String orderState;

    /**
     * 订单开始时间
     */
    @TableField(value = "starttime")
    @DEField(name = "starttime")
    @JsonProperty("starttime")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "starttime" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "starttime", notes = "订单开始时间")
    private Timestamp startTime;

    /**
     * 更新人
     */
    @TableField(value = "updateman")
    @DEField(name = "updateman" , preType = DEPredefinedFieldType.UPDATEMAN , dict = "SysOperator")
    @JsonProperty("updateman")
    @JSONField(name = "updateman")
    @ApiModelProperty(value = "updateman", notes = "更新人")
    private String updateMan;

    /**
     * 工作流步骤
     */
    @TableField(value = "wfstep")
    @DEField(name = "wfstep" , dict = "ORDERSTEP")
    @JsonProperty("wfstep")
    @JSONField(name = "wfstep")
    @ApiModelProperty(value = "wfstep", notes = "工作流步骤")
    private String wfStep;

    /**
     * 建立人
     */
    @TableField(value = "createman" , fill = FieldFill.INSERT)
    @DEField(name = "createman" , preType = DEPredefinedFieldType.CREATEMAN , dict = "SysOperator")
    @JsonProperty("createman")
    @JSONField(name = "createman")
    @ApiModelProperty(value = "createman", notes = "建立人")
    private String createMan;

    /**
     * 订单名称
     */
    @TableField(value = "ibizordername")
    @DEField(name = "ibizordername")
    @JsonProperty("ibizordername")
    @JSONField(name = "ibizordername")
    @ApiModelProperty(value = "ibizordername", notes = "订单名称")
    private String ibizOrderName;

    /**
     * 订单时间
     */
    @TableField(value = "ordertime")
    @DEField(name = "ordertime")
    @JsonProperty("ordertime")
    @JsonFormat(pattern = "yyyy-MM-dd", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "ordertime" , format = "yyyy-MM-dd")
    @ApiModelProperty(value = "ordertime", notes = "订单时间")
    private Timestamp orderTime;

    /**
     * 备注
     */
    @TableField(value = "memo")
    @DEField(name = "memo")
    @JsonProperty("memo")
    @JSONField(name = "memo")
    @ApiModelProperty(value = "memo", notes = "备注")
    private String memo;

    /**
     * 客户名称
     */
    @TableField(value = "ibizcustomername" , exist = false)
    @DEField(name = "ibizcustomername")
    @JsonProperty("ibizcustomername")
    @JSONField(name = "ibizcustomername")
    @ApiModelProperty(value = "ibizcustomername", notes = "客户名称")
    private String ibizCustomerName;

    /**
     * 客户标识
     */
    @TableField(value = "ibizcustomerid")
    @DEField(name = "ibizcustomerid")
    @JsonProperty("ibizcustomerid")
    @JSONField(name = "ibizcustomerid")
    @ApiModelProperty(value = "ibizcustomerid", notes = "客户标识")
    private String ibizCustomerId;


    /**
     * 客户
     */
    @JsonIgnore
    @JSONField(serialize = false)
    @TableField(exist = false)
    @ApiModelProperty(value = "ibizcustomer", notes = "")
    private IBIZCustomer ibizcustomer;


    /**
     * 设置 [图片]
     */
    public void setTp(String tp) {
        this.tp = tp;
        this.modify("tp", tp);
    }

    /**
     * 设置 [订单结束时间]
     */
    public void setEndTime(Timestamp endTime) {
        this.endTime = endTime;
        this.modify("endtime", endTime);
    }

    /**
     * 设置 [工作流状态]
     */
    public void setWfState(Integer wfState) {
        this.wfState = wfState;
        this.modify("wfstate", wfState);
    }


    /**
     * 设置 [审批意见]
     */
    public void setOpinion(String opinion) {
        this.opinion = opinion;
        this.modify("opinion", opinion);
    }


    /**
     * 设置 [订单类型]
     */
    public void setOrderType(String orderType) {
        this.orderType = orderType;
        this.modify("ordertype", orderType);
    }

    /**
     * 设置 [明细数]
     */
    public void setDetailNum(Integer detailNum) {
        this.detailNum = detailNum;
        this.modify("detailnum", detailNum);
    }

    /**
     * 设置 [工作流实例]
     */
    public void setWfInstanceId(String wfInstanceId) {
        this.wfInstanceId = wfInstanceId;
        this.modify("wfinstanceid", wfInstanceId);
    }

    /**
     * 设置 [总计]
     */
    public void setAmount(BigDecimal amount) {
        this.amount = amount;
        this.modify("amount", amount);
    }

    /**
     * 设置 [订单编号]
     */
    public void setOrderUid(String orderUid) {
        this.orderUid = orderUid;
        this.modify("orderuid", orderUid);
    }


    /**
     * 设置 [订单状态]
     */
    public void setOrderState(String orderState) {
        this.orderState = orderState;
        this.modify("orderstate", orderState);
    }

    /**
     * 设置 [订单开始时间]
     */
    public void setStartTime(Timestamp startTime) {
        this.startTime = startTime;
        this.modify("starttime", startTime);
    }


    /**
     * 设置 [工作流步骤]
     */
    public void setWfStep(String wfStep) {
        this.wfStep = wfStep;
        this.modify("wfstep", wfStep);
    }


    /**
     * 设置 [订单名称]
     */
    public void setIbizOrderName(String ibizOrderName) {
        this.ibizOrderName = ibizOrderName;
        this.modify("ibizordername", ibizOrderName);
    }

    /**
     * 设置 [订单时间]
     */
    public void setOrderTime(Timestamp orderTime) {
        this.orderTime = orderTime;
        this.modify("ordertime", orderTime);
    }

    /**
     * 设置 [备注]
     */
    public void setMemo(String memo) {
        this.memo = memo;
        this.modify("memo", memo);
    }

    /**
     * 设置 [客户名称]
     */
    public void setIbizCustomerName(String ibizCustomerName) {
        this.ibizCustomerName = ibizCustomerName;
        this.modify("ibizcustomername", ibizCustomerName);
    }

    /**
     * 设置 [客户标识]
     */
    public void setIbizCustomerId(String ibizCustomerId) {
        this.ibizCustomerId = ibizCustomerId;
        this.modify("ibizcustomerid", ibizCustomerId);
    }



    

    /**
     * 复制当前对象数据到目标对象(粘贴重置)
     * @param targetEntity 目标数据对象
     * @param bIncEmpty  是否包括空值
     * @param <T>
     * @return
     */
    @Override
    public <T> T copyTo(T targetEntity, boolean bIncEmpty) {
        this.reset("ibizorderid");        
        return super.copyTo(targetEntity, bIncEmpty);
    }    
}