package cn.ibizlab.core.sample.domain;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.math.BigInteger;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import org.springframework.util.ObjectUtils;
import org.springframework.util.DigestUtils;
import org.springframework.util.Assert;
import cn.ibizlab.util.domain.EntityBase;
import cn.ibizlab.util.annotation.DEField;
import cn.ibizlab.util.enums.DEPredefinedFieldType;
import cn.ibizlab.util.enums.DEFieldDefaultValueType;
import cn.ibizlab.util.helper.DataObject;
import cn.ibizlab.util.annotation.Audit;
import cn.ibizlab.util.enums.DupCheck;
import cn.ibizlab.util.domain.EntityMP;
import java.io.Serializable;
import lombok.*;
import lombok.experimental.Accessors;
import org.springframework.data.annotation.Transient;
import org.springframework.data.annotation.Id;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.baomidou.mybatisplus.annotation.*;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;

@Getter
@Setter
@NoArgsConstructor
@JsonIgnoreProperties(value = "handler")
@TableName(value = "T_IBIZAPPVIEW", resultMap = "IBIZAPPVIEWResultMap")
@ApiModel(value = "IBIZAPPVIEW", description = "应用视图")
public class IBIZAPPVIEW extends EntityMP implements Serializable
{

    /**
     * 建立人
     */
    @TableField(value = "createman" , fill = FieldFill.INSERT)
    @DEField(name = "createman" , preType = DEPredefinedFieldType.CREATEMAN , dict = "SysOperator")
    @JsonProperty("createman")
    @JSONField(name = "createman")
    @ApiModelProperty(value = "createman", notes = "建立人")
    private String createMan;

    /**
     * 建立时间
     */
    @TableField(value = "createdate" , fill = FieldFill.INSERT)
    @DEField(name = "createdate" , preType = DEPredefinedFieldType.CREATEDATE)
    @JsonProperty("createdate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createdate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "createdate", notes = "建立时间")
    private Timestamp createDate;

    /**
     * 应用视图名称
     */
    @TableField(value = "ibizappviewname")
    @DEField(name = "ibizappviewname")
    @JsonProperty("ibizappviewname")
    @JSONField(name = "ibizappviewname")
    @ApiModelProperty(value = "ibizappviewname", notes = "应用视图名称")
    private String ibizappviewName;

    /**
     * 应用视图标识
     */
    @Id
    @TableId(value = "ibizappviewid" , type = IdType.ASSIGN_UUID)
    @DEField(name = "ibizappviewid" , isKeyField = true)
    @JsonProperty("ibizappviewid")
    @JSONField(name = "ibizappviewid")
    @ApiModelProperty(value = "ibizappviewid", notes = "应用视图标识")
    private String ibizappviewid;

    /**
     * 更新人
     */
    @TableField(value = "updateman")
    @DEField(name = "updateman" , preType = DEPredefinedFieldType.UPDATEMAN , dict = "SysOperator")
    @JsonProperty("updateman")
    @JSONField(name = "updateman")
    @ApiModelProperty(value = "updateman", notes = "更新人")
    private String updateMan;

    /**
     * 更新时间
     */
    @TableField(value = "updatedate")
    @DEField(name = "updatedate" , preType = DEPredefinedFieldType.UPDATEDATE)
    @JsonProperty("updatedate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatedate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "updatedate", notes = "更新时间")
    private Timestamp updateDate;

    /**
     * 应用视图类型
     */
    @TableField(value = "ibizappviewtype")
    @DEField(name = "ibizappviewtype" , dict = "AppViewType")
    @JsonProperty("ibizappviewtype")
    @JSONField(name = "ibizappviewtype")
    @ApiModelProperty(value = "ibizappviewtype", notes = "应用视图类型")
    private String ibizappviewtype;

    /**
     * 文档地址
     */
    @TableField(value = "documentaddress")
    @DEField(name = "documentaddress")
    @JsonProperty("documentaddress")
    @JSONField(name = "documentaddress")
    @ApiModelProperty(value = "documentaddress", notes = "文档地址")
    private String documentaddress;

    /**
     * 示例地址
     */
    @TableField(value = "instanceaddress")
    @DEField(name = "instanceaddress")
    @JsonProperty("instanceaddress")
    @JSONField(name = "instanceaddress")
    @ApiModelProperty(value = "instanceaddress", notes = "示例地址")
    private String instanceaddress;

    /**
     * 视图描述
     */
    @TableField(value = "viewdescription")
    @DEField(name = "viewdescription")
    @JsonProperty("viewdescription")
    @JSONField(name = "viewdescription")
    @ApiModelProperty(value = "viewdescription", notes = "视图描述")
    private String viewdescription;

    /**
     * 数量
     */
    @TableField(value = "amount")
    @DEField(name = "amount")
    @JsonProperty("amount")
    @JSONField(name = "amount")
    @ApiModelProperty(value = "amount", notes = "数量")
    private Integer amount;






    /**
     * 设置 [应用视图名称]
     */
    public void setIbizappviewName(String ibizappviewName) {
        this.ibizappviewName = ibizappviewName;
        this.modify("ibizappviewname", ibizappviewName);
    }




    /**
     * 设置 [应用视图类型]
     */
    public void setIbizappviewtype(String ibizappviewtype) {
        this.ibizappviewtype = ibizappviewtype;
        this.modify("ibizappviewtype", ibizappviewtype);
    }

    /**
     * 设置 [文档地址]
     */
    public void setDocumentaddress(String documentaddress) {
        this.documentaddress = documentaddress;
        this.modify("documentaddress", documentaddress);
    }

    /**
     * 设置 [示例地址]
     */
    public void setInstanceaddress(String instanceaddress) {
        this.instanceaddress = instanceaddress;
        this.modify("instanceaddress", instanceaddress);
    }

    /**
     * 设置 [视图描述]
     */
    public void setViewdescription(String viewdescription) {
        this.viewdescription = viewdescription;
        this.modify("viewdescription", viewdescription);
    }

    /**
     * 设置 [数量]
     */
    public void setAmount(Integer amount) {
        this.amount = amount;
        this.modify("amount", amount);
    }



    

    /**
     * 复制当前对象数据到目标对象(粘贴重置)
     * @param targetEntity 目标数据对象
     * @param bIncEmpty  是否包括空值
     * @param <T>
     * @return
     */
    @Override
    public <T> T copyTo(T targetEntity, boolean bIncEmpty) {
        this.reset("ibizappviewid");        
        return super.copyTo(targetEntity, bIncEmpty);
    }    
}