package cn.ibizlab.demoapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.demoapi.dto.*;
import cn.ibizlab.demoapi.mapping.*;
import cn.ibizlab.core.sample.domain.IBIZSample0008;
import cn.ibizlab.core.sample.service.IBIZSample0008Service;
import cn.ibizlab.core.sample.filter.IBIZSample0008SearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"自循环流程" })
@RestController("demoapi-ibizsample0008")
@RequestMapping("${ibiz.rest.basePath.demoapi:/demoapi/}")
public class IBIZSample0008Resource {

    @Autowired
    public IBIZSample0008Service ibizSample0008Service;

    @Autowired
    @Lazy
    public IBIZSample0008DTOMapping ibizSample0008DtoMapping;


    @ApiOperation(value = "创建Create", tags = {"自循环流程" },  notes = "IBIZSample0008-Create")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0008-Create-all') or hasPermission(this.ibizSample0008DtoMapping.toDomain(#dto),'DemoSys-IBIZSample0008-Create')")
    @RequestMapping(method = RequestMethod.POST, value = "ibizsample0008s")
    public ResponseEntity<IBIZSample0008DTO> create
            (@Validated @RequestBody IBIZSample0008DTO dto) {
        IBIZSample0008 domain = ibizSample0008DtoMapping.toDomain(dto);
        ibizSample0008Service.create(domain);
        IBIZSample0008 rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0008DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "获取Get", tags = {"自循环流程" },  notes = "IBIZSample0008-Get")
    @PostAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0008-Get-all') or hasPermission(this.ibizSample0008DtoMapping.toDomain(returnObject.body),'DemoSys-IBIZSample0008-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizsample0008s/{ibizSample0008Id}")
    public ResponseEntity<IBIZSample0008DTO> getByIbizSample0008Id
            (@PathVariable("ibizSample0008Id") String ibizSample0008Id) {
        IBIZSample0008 rt = ibizSample0008Service.get(ibizSample0008Id);
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0008DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "删除Remove", tags = {"自循环流程" },  notes = "IBIZSample0008-Remove")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0008-Remove-all') or hasPermission(this.ibizSample0008Service.get(#ibizSample0008Id),'DemoSys-IBIZSample0008-Remove')")
    @RequestMapping(method = RequestMethod.DELETE, value = "ibizsample0008s/{ibizSample0008Id}")
    public ResponseEntity<Boolean> removeByIbizSample0008Id
            (@PathVariable("ibizSample0008Id") String ibizSample0008Id) {
        Boolean rt = ibizSample0008Service.remove(ibizSample0008Id);
        return ResponseEntity.status(HttpStatus.OK).body(rt);
    }

    @ApiOperation(value = "更新Update", tags = {"自循环流程" },  notes = "IBIZSample0008-Update")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0008-Update-all') or hasPermission(this.ibizSample0008Service.get(#ibizSample0008Id),'DemoSys-IBIZSample0008-Update')")
    @VersionCheck(entity = "ibizsample0008" , versionfield = "updateDate")
    @RequestMapping(method = RequestMethod.PUT, value = "ibizsample0008s/{ibizSample0008Id}")
    public ResponseEntity<IBIZSample0008DTO> updateByIbizSample0008Id
            (@PathVariable("ibizSample0008Id") String ibizSample0008Id, @Validated @RequestBody IBIZSample0008DTO dto) {
        IBIZSample0008 domain = ibizSample0008DtoMapping.toDomain(dto);
        domain.setIbizSample0008Id(ibizSample0008Id);
        ibizSample0008Service.update(domain);
        IBIZSample0008 rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0008DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "校验CheckKey", tags = {"自循环流程" },  notes = "IBIZSample0008-CheckKey")
    @RequestMapping(method = RequestMethod.POST, value = "ibizsample0008s/checkkey")
    public ResponseEntity<Integer> checkKey
            (@Validated @RequestBody IBIZSample0008DTO dto) {
        IBIZSample0008 domain = ibizSample0008DtoMapping.toDomain(dto);
        Integer rt = ibizSample0008Service.checkKey(domain);
        return ResponseEntity.status(HttpStatus.OK).body(rt);
    }

    @ApiOperation(value = "草稿GetDraft", tags = {"自循环流程" },  notes = "IBIZSample0008-GetDraft")
    @RequestMapping(method = RequestMethod.GET, value = "ibizsample0008s/getdraft")
    public ResponseEntity<IBIZSample0008DTO> getDraft
            (IBIZSample0008DTO dto) {
        IBIZSample0008 domain = ibizSample0008DtoMapping.toDomain(dto);
        IBIZSample0008 rt = ibizSample0008Service.getDraft(domain);
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0008DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "保存Save", tags = {"自循环流程" },  notes = "IBIZSample0008-Save")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0008-Save-all') or hasPermission(this.ibizSample0008DtoMapping.toDomain(#dto),'DemoSys-IBIZSample0008-Save')")
    @RequestMapping(method = RequestMethod.POST, value = "ibizsample0008s/save")
    public ResponseEntity<IBIZSample0008DTO> save
            (@Validated @RequestBody IBIZSample0008DTO dto) {
        IBIZSample0008 domain = ibizSample0008DtoMapping.toDomain(dto);
        ibizSample0008Service.save(domain);
        IBIZSample0008 rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0008DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "查询FetchDefault", tags = {"自循环流程" },  notes = "IBIZSample0008-FetchDefault")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0008-searchDefault-all','DemoSys-IBIZSample0008-Get-all') or hasPermission(#dto,'DemoSys-IBIZSample0008-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizsample0008s/fetchdefault")
    public ResponseEntity<List<IBIZSample0008DTO>> fetchDefault
            (IBIZSample0008SearchContext dto) {
        Page<IBIZSample0008> domains = ibizSample0008Service.searchDefault(dto) ;
        List<IBIZSample0008DTO> list = ibizSample0008DtoMapping.toDto(domains.getContent());
            return ResponseEntity.status(HttpStatus.OK)
            .header("x-page", String.valueOf(dto.getPageable().getPageNumber()))
            .header("x-per-page", String.valueOf(dto.getPageable().getPageSize()))
            .header("x-total", String.valueOf(domains.getTotalElements()))
            .body(list);
    }


    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0008-Create-all')")
    @ApiOperation(value = "批量新建自循环流程", tags = {"自循环流程" },  notes = "批量新建自循环流程")
	@RequestMapping(method = RequestMethod.POST, value = "ibizsample0008s/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<IBIZSample0008DTO> dtos) {
        ibizSample0008Service.createBatch(ibizSample0008DtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0008-Update-all')")
    @ApiOperation(value = "批量更新自循环流程", tags = {"自循环流程" },  notes = "批量更新自循环流程")
	@RequestMapping(method = RequestMethod.PUT, value = "ibizsample0008s/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<IBIZSample0008DTO> dtos) {
        ibizSample0008Service.updateBatch(ibizSample0008DtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0008-Save-all')")
    @ApiOperation(value = "批量保存自循环流程", tags = {"自循环流程" },  notes = "批量保存自循环流程")
	@RequestMapping(method = RequestMethod.POST, value = "ibizsample0008s/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<IBIZSample0008DTO> dtos) {
        ibizSample0008Service.saveBatch(ibizSample0008DtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0008-Save-all')")
    @ApiOperation(value = "批量导入自循环流程", tags = {"自循环流程" },  notes = "批量导入自循环流程")
	@RequestMapping(method = RequestMethod.POST, value = "ibizsample0008s/import")
    public ResponseEntity<Map> importData(@RequestParam(value = "config") String config ,@RequestBody List<IBIZSample0008DTO> dtos) {
        Map rs=new HashMap();
        if(ObjectUtils.isEmpty(dtos)){
            rs.put("rst", 1);
            rs.put("msg", "未传入内容");
            return ResponseEntity.status(HttpStatus.NO_CONTENT).body(rs);
        }
        else{
            List<IBIZSample0008> list=ibizSample0008DtoMapping.toDomain(dtos);
            List<IBIZSample0008> rtList=new ArrayList();
            list.forEach(item->{
                if(ibizSample0008Service.save(item))
                    rtList.add(item);
            });
            rs.put("rst", 0);
            rs.put("data",rtList);
        }
        return  ResponseEntity.status(HttpStatus.OK).body(rs);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0008-Remove-all')")
    @ApiOperation(value = "批量删除自循环流程", tags = {"自循环流程" },  notes = "批量删除自循环流程")
	@RequestMapping(method = RequestMethod.DELETE, value = {"ibizsample0008s","/ibizsample0008s/batch"})
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        ibizSample0008Service.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }
}
