package cn.ibizlab.demoapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.demoapi.dto.*;
import cn.ibizlab.demoapi.mapping.*;
import cn.ibizlab.core.sample.domain.IBIZSample0005;
import cn.ibizlab.core.sample.service.IBIZSample0005Service;
import cn.ibizlab.core.sample.filter.IBIZSample0005SearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"多模式流程" })
@RestController("demoapi-ibizsample0005")
@RequestMapping("${ibiz.rest.basePath.demoapi:/demoapi/}")
public class IBIZSample0005Resource {

    @Autowired
    public IBIZSample0005Service ibizSample0005Service;

    @Autowired
    @Lazy
    public IBIZSample0005DTOMapping ibizSample0005DtoMapping;


    @ApiOperation(value = "创建Create", tags = {"多模式流程" },  notes = "IBIZSample0005-Create")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0005-Create-all') or hasPermission(this.ibizSample0005DtoMapping.toDomain(#dto),'DemoSys-IBIZSample0005-Create')")
    @RequestMapping(method = RequestMethod.POST, value = "ibizsample0005s")
    public ResponseEntity<IBIZSample0005DTO> create
            (@Validated @RequestBody IBIZSample0005DTO dto) {
        IBIZSample0005 domain = ibizSample0005DtoMapping.toDomain(dto);
        ibizSample0005Service.create(domain);
        IBIZSample0005 rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0005DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "获取Get", tags = {"多模式流程" },  notes = "IBIZSample0005-Get")
    @PostAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0005-Get-all') or hasPermission(this.ibizSample0005DtoMapping.toDomain(returnObject.body),'DemoSys-IBIZSample0005-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizsample0005s/{ibizSample0005Id}")
    public ResponseEntity<IBIZSample0005DTO> getByIbizSample0005Id
            (@PathVariable("ibizSample0005Id") String ibizSample0005Id) {
        IBIZSample0005 rt = ibizSample0005Service.get(ibizSample0005Id);
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0005DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "删除Remove", tags = {"多模式流程" },  notes = "IBIZSample0005-Remove")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0005-Remove-all') or hasPermission(this.ibizSample0005Service.get(#ibizSample0005Id),'DemoSys-IBIZSample0005-Remove')")
    @RequestMapping(method = RequestMethod.DELETE, value = "ibizsample0005s/{ibizSample0005Id}")
    public ResponseEntity<Boolean> removeByIbizSample0005Id
            (@PathVariable("ibizSample0005Id") String ibizSample0005Id) {
        Boolean rt = ibizSample0005Service.remove(ibizSample0005Id);
        return ResponseEntity.status(HttpStatus.OK).body(rt);
    }

    @ApiOperation(value = "更新Update", tags = {"多模式流程" },  notes = "IBIZSample0005-Update")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0005-Update-all') or hasPermission(this.ibizSample0005Service.get(#ibizSample0005Id),'DemoSys-IBIZSample0005-Update')")
    @VersionCheck(entity = "ibizsample0005" , versionfield = "updateDate")
    @RequestMapping(method = RequestMethod.PUT, value = "ibizsample0005s/{ibizSample0005Id}")
    public ResponseEntity<IBIZSample0005DTO> updateByIbizSample0005Id
            (@PathVariable("ibizSample0005Id") String ibizSample0005Id, @Validated @RequestBody IBIZSample0005DTO dto) {
        IBIZSample0005 domain = ibizSample0005DtoMapping.toDomain(dto);
        domain.setIbizSample0005Id(ibizSample0005Id);
        ibizSample0005Service.update(domain);
        IBIZSample0005 rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0005DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "校验CheckKey", tags = {"多模式流程" },  notes = "IBIZSample0005-CheckKey")
    @RequestMapping(method = RequestMethod.POST, value = "ibizsample0005s/checkkey")
    public ResponseEntity<Integer> checkKey
            (@Validated @RequestBody IBIZSample0005DTO dto) {
        IBIZSample0005 domain = ibizSample0005DtoMapping.toDomain(dto);
        Integer rt = ibizSample0005Service.checkKey(domain);
        return ResponseEntity.status(HttpStatus.OK).body(rt);
    }

    @ApiOperation(value = "草稿GetDraft", tags = {"多模式流程" },  notes = "IBIZSample0005-GetDraft")
    @RequestMapping(method = RequestMethod.GET, value = "ibizsample0005s/getdraft")
    public ResponseEntity<IBIZSample0005DTO> getDraft
            (IBIZSample0005DTO dto) {
        IBIZSample0005 domain = ibizSample0005DtoMapping.toDomain(dto);
        IBIZSample0005 rt = ibizSample0005Service.getDraft(domain);
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0005DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "保存Save", tags = {"多模式流程" },  notes = "IBIZSample0005-Save")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0005-Save-all') or hasPermission(this.ibizSample0005DtoMapping.toDomain(#dto),'DemoSys-IBIZSample0005-Save')")
    @RequestMapping(method = RequestMethod.POST, value = "ibizsample0005s/save")
    public ResponseEntity<IBIZSample0005DTO> save
            (@Validated @RequestBody IBIZSample0005DTO dto) {
        IBIZSample0005 domain = ibizSample0005DtoMapping.toDomain(dto);
        ibizSample0005Service.save(domain);
        IBIZSample0005 rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0005DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "查询FetchDefault", tags = {"多模式流程" },  notes = "IBIZSample0005-FetchDefault")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0005-searchDefault-all','DemoSys-IBIZSample0005-Get-all') or hasPermission(#dto,'DemoSys-IBIZSample0005-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizsample0005s/fetchdefault")
    public ResponseEntity<List<IBIZSample0005DTO>> fetchDefault
            (IBIZSample0005SearchContext dto) {
        Page<IBIZSample0005> domains = ibizSample0005Service.searchDefault(dto) ;
        List<IBIZSample0005DTO> list = ibizSample0005DtoMapping.toDto(domains.getContent());
            return ResponseEntity.status(HttpStatus.OK)
            .header("x-page", String.valueOf(dto.getPageable().getPageNumber()))
            .header("x-per-page", String.valueOf(dto.getPageable().getPageSize()))
            .header("x-total", String.valueOf(domains.getTotalElements()))
            .body(list);
    }


    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0005-Create-all')")
    @ApiOperation(value = "批量新建多模式流程", tags = {"多模式流程" },  notes = "批量新建多模式流程")
	@RequestMapping(method = RequestMethod.POST, value = "ibizsample0005s/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<IBIZSample0005DTO> dtos) {
        ibizSample0005Service.createBatch(ibizSample0005DtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0005-Update-all')")
    @ApiOperation(value = "批量更新多模式流程", tags = {"多模式流程" },  notes = "批量更新多模式流程")
	@RequestMapping(method = RequestMethod.PUT, value = "ibizsample0005s/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<IBIZSample0005DTO> dtos) {
        ibizSample0005Service.updateBatch(ibizSample0005DtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0005-Save-all')")
    @ApiOperation(value = "批量保存多模式流程", tags = {"多模式流程" },  notes = "批量保存多模式流程")
	@RequestMapping(method = RequestMethod.POST, value = "ibizsample0005s/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<IBIZSample0005DTO> dtos) {
        ibizSample0005Service.saveBatch(ibizSample0005DtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0005-Save-all')")
    @ApiOperation(value = "批量导入多模式流程", tags = {"多模式流程" },  notes = "批量导入多模式流程")
	@RequestMapping(method = RequestMethod.POST, value = "ibizsample0005s/import")
    public ResponseEntity<Map> importData(@RequestParam(value = "config") String config ,@RequestBody List<IBIZSample0005DTO> dtos) {
        Map rs=new HashMap();
        if(ObjectUtils.isEmpty(dtos)){
            rs.put("rst", 1);
            rs.put("msg", "未传入内容");
            return ResponseEntity.status(HttpStatus.NO_CONTENT).body(rs);
        }
        else{
            List<IBIZSample0005> list=ibizSample0005DtoMapping.toDomain(dtos);
            List<IBIZSample0005> rtList=new ArrayList();
            list.forEach(item->{
                if(ibizSample0005Service.save(item))
                    rtList.add(item);
            });
            rs.put("rst", 0);
            rs.put("data",rtList);
        }
        return  ResponseEntity.status(HttpStatus.OK).body(rs);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0005-Remove-all')")
    @ApiOperation(value = "批量删除多模式流程", tags = {"多模式流程" },  notes = "批量删除多模式流程")
	@RequestMapping(method = RequestMethod.DELETE, value = {"ibizsample0005s","/ibizsample0005s/batch"})
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        ibizSample0005Service.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }
}
