package cn.ibizlab.demoapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.demoapi.dto.*;
import cn.ibizlab.demoapi.mapping.*;
import cn.ibizlab.core.sample.domain.IBIZAPPCTRL;
import cn.ibizlab.core.sample.service.IBIZAPPCTRLService;
import cn.ibizlab.core.sample.filter.IBIZAPPCTRLSearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"应用部件" })
@RestController("demoapi-ibizappctrl")
@RequestMapping("${ibiz.rest.basePath.demoapi:/demoapi/}")
public class IBIZAPPCTRLResource {

    @Autowired
    public IBIZAPPCTRLService ibizappctrlService;

    @Autowired
    @Lazy
    public IBIZAPPCTRLDTOMapping ibizappctrldtoMapping;


    @ApiOperation(value = "创建Create", tags = {"应用部件" },  notes = "IBIZAPPCTRL-Create")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZAPPCTRL-Create-all') or hasPermission(this.ibizappctrldtoMapping.toDomain(#dto),'DemoSys-IBIZAPPCTRL-Create')")
    @RequestMapping(method = RequestMethod.POST, value = "ibizappctrls")
    public ResponseEntity<IBIZAPPCTRLDTO> create
            (@Validated @RequestBody IBIZAPPCTRLDTO dto) {
        IBIZAPPCTRL domain = ibizappctrldtoMapping.toDomain(dto);
        ibizappctrlService.create(domain);
        IBIZAPPCTRL rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizappctrldtoMapping.toDto(rt));
    }

    @ApiOperation(value = "获取Get", tags = {"应用部件" },  notes = "IBIZAPPCTRL-Get")
    @PostAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZAPPCTRL-Get-all') or hasPermission(this.ibizappctrldtoMapping.toDomain(returnObject.body),'DemoSys-IBIZAPPCTRL-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizappctrls/{ibizappctrlid}")
    public ResponseEntity<IBIZAPPCTRLDTO> getByIbizappctrlid
            (@PathVariable("ibizappctrlid") String ibizappctrlid) {
        IBIZAPPCTRL rt = ibizappctrlService.get(ibizappctrlid);
        return ResponseEntity.status(HttpStatus.OK).body(ibizappctrldtoMapping.toDto(rt));
    }

    @ApiOperation(value = "删除Remove", tags = {"应用部件" },  notes = "IBIZAPPCTRL-Remove")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZAPPCTRL-Remove-all') or hasPermission(this.ibizappctrlService.get(#ibizappctrlid),'DemoSys-IBIZAPPCTRL-Remove')")
    @RequestMapping(method = RequestMethod.DELETE, value = "ibizappctrls/{ibizappctrlid}")
    public ResponseEntity<Boolean> removeByIbizappctrlid
            (@PathVariable("ibizappctrlid") String ibizappctrlid) {
        Boolean rt = ibizappctrlService.remove(ibizappctrlid);
        return ResponseEntity.status(HttpStatus.OK).body(rt);
    }

    @ApiOperation(value = "更新Update", tags = {"应用部件" },  notes = "IBIZAPPCTRL-Update")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZAPPCTRL-Update-all') or hasPermission(this.ibizappctrlService.get(#ibizappctrlid),'DemoSys-IBIZAPPCTRL-Update')")
    @VersionCheck(entity = "ibizappctrl" , versionfield = "updateDate")
    @RequestMapping(method = RequestMethod.PUT, value = "ibizappctrls/{ibizappctrlid}")
    public ResponseEntity<IBIZAPPCTRLDTO> updateByIbizappctrlid
            (@PathVariable("ibizappctrlid") String ibizappctrlid, @Validated @RequestBody IBIZAPPCTRLDTO dto) {
        IBIZAPPCTRL domain = ibizappctrldtoMapping.toDomain(dto);
        domain.setIbizappctrlid(ibizappctrlid);
        ibizappctrlService.update(domain);
        IBIZAPPCTRL rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizappctrldtoMapping.toDto(rt));
    }

    @ApiOperation(value = "校验CheckKey", tags = {"应用部件" },  notes = "IBIZAPPCTRL-CheckKey")
    @RequestMapping(method = RequestMethod.POST, value = "ibizappctrls/checkkey")
    public ResponseEntity<Integer> checkKey
            (@Validated @RequestBody IBIZAPPCTRLDTO dto) {
        IBIZAPPCTRL domain = ibizappctrldtoMapping.toDomain(dto);
        Integer rt = ibizappctrlService.checkKey(domain);
        return ResponseEntity.status(HttpStatus.OK).body(rt);
    }

    @ApiOperation(value = "草稿GetDraft", tags = {"应用部件" },  notes = "IBIZAPPCTRL-GetDraft")
    @RequestMapping(method = RequestMethod.GET, value = "ibizappctrls/getdraft")
    public ResponseEntity<IBIZAPPCTRLDTO> getDraft
            (IBIZAPPCTRLDTO dto) {
        IBIZAPPCTRL domain = ibizappctrldtoMapping.toDomain(dto);
        IBIZAPPCTRL rt = ibizappctrlService.getDraft(domain);
        return ResponseEntity.status(HttpStatus.OK).body(ibizappctrldtoMapping.toDto(rt));
    }

    @ApiOperation(value = "保存Save", tags = {"应用部件" },  notes = "IBIZAPPCTRL-Save")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZAPPCTRL-Save-all') or hasPermission(this.ibizappctrldtoMapping.toDomain(#dto),'DemoSys-IBIZAPPCTRL-Save')")
    @RequestMapping(method = RequestMethod.POST, value = "ibizappctrls/save")
    public ResponseEntity<IBIZAPPCTRLDTO> save
            (@Validated @RequestBody IBIZAPPCTRLDTO dto) {
        IBIZAPPCTRL domain = ibizappctrldtoMapping.toDomain(dto);
        ibizappctrlService.save(domain);
        IBIZAPPCTRL rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizappctrldtoMapping.toDto(rt));
    }

    @ApiOperation(value = "查询FetchDefault", tags = {"应用部件" },  notes = "IBIZAPPCTRL-FetchDefault")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZAPPCTRL-searchDefault-all','DemoSys-IBIZAPPCTRL-Get-all') or hasPermission(#dto,'DemoSys-IBIZAPPCTRL-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizappctrls/fetchdefault")
    public ResponseEntity<List<IBIZAPPCTRLDTO>> fetchDefault
            (IBIZAPPCTRLSearchContext dto) {
        Page<IBIZAPPCTRL> domains = ibizappctrlService.searchDefault(dto) ;
        List<IBIZAPPCTRLDTO> list = ibizappctrldtoMapping.toDto(domains.getContent());
            return ResponseEntity.status(HttpStatus.OK)
            .header("x-page", String.valueOf(dto.getPageable().getPageNumber()))
            .header("x-per-page", String.valueOf(dto.getPageable().getPageSize()))
            .header("x-total", String.valueOf(domains.getTotalElements()))
            .body(list);
    }


    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZAPPCTRL-Create-all')")
    @ApiOperation(value = "批量新建应用部件", tags = {"应用部件" },  notes = "批量新建应用部件")
	@RequestMapping(method = RequestMethod.POST, value = "ibizappctrls/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<IBIZAPPCTRLDTO> dtos) {
        ibizappctrlService.createBatch(ibizappctrldtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZAPPCTRL-Update-all')")
    @ApiOperation(value = "批量更新应用部件", tags = {"应用部件" },  notes = "批量更新应用部件")
	@RequestMapping(method = RequestMethod.PUT, value = "ibizappctrls/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<IBIZAPPCTRLDTO> dtos) {
        ibizappctrlService.updateBatch(ibizappctrldtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZAPPCTRL-Save-all')")
    @ApiOperation(value = "批量保存应用部件", tags = {"应用部件" },  notes = "批量保存应用部件")
	@RequestMapping(method = RequestMethod.POST, value = "ibizappctrls/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<IBIZAPPCTRLDTO> dtos) {
        ibizappctrlService.saveBatch(ibizappctrldtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZAPPCTRL-Save-all')")
    @ApiOperation(value = "批量导入应用部件", tags = {"应用部件" },  notes = "批量导入应用部件")
	@RequestMapping(method = RequestMethod.POST, value = "ibizappctrls/import")
    public ResponseEntity<Map> importData(@RequestParam(value = "config") String config ,@RequestBody List<IBIZAPPCTRLDTO> dtos) {
        Map rs=new HashMap();
        if(ObjectUtils.isEmpty(dtos)){
            rs.put("rst", 1);
            rs.put("msg", "未传入内容");
            return ResponseEntity.status(HttpStatus.NO_CONTENT).body(rs);
        }
        else{
            List<IBIZAPPCTRL> list=ibizappctrldtoMapping.toDomain(dtos);
            List<IBIZAPPCTRL> rtList=new ArrayList();
            list.forEach(item->{
                if(ibizappctrlService.save(item))
                    rtList.add(item);
            });
            rs.put("rst", 0);
            rs.put("data",rtList);
        }
        return  ResponseEntity.status(HttpStatus.OK).body(rs);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZAPPCTRL-Remove-all')")
    @ApiOperation(value = "批量删除应用部件", tags = {"应用部件" },  notes = "批量删除应用部件")
	@RequestMapping(method = RequestMethod.DELETE, value = {"ibizappctrls","/ibizappctrls/batch"})
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        ibizappctrlService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }
}
