package cn.ibizlab.demoapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.*;
import lombok.experimental.Accessors;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 服务DTO对象[IBIZSupplierDTO]
 */
@Getter
@Setter
@NoArgsConstructor
@ApiModel("供货商")
public class IBIZSupplierDTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 地址
     */
    @JsonProperty("address")
    @JSONField(name = "address")
    @ApiModelProperty("地址")
    private String address;

    /**
     * 创建人
     */
    @JsonProperty("createby")
    @JSONField(name = "createby")
    @ApiModelProperty("创建人")
    private String createBy;

    /**
     * 创建时间
     */
    @JsonProperty("createtime")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createtime" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("创建时间")
    private Timestamp createTime;

    /**
     * 邮箱
     */
    @JsonProperty("email")
    @JSONField(name = "email")
    @ApiModelProperty("邮箱")
    private String eMail;

    /**
     * 供应商标识
     */
    @JsonProperty("supplierid")
    @JSONField(name = "supplierid")
    @ApiModelProperty("供应商标识")
    private String supplierId;

    /**
     * 供应商名称
     */
    @JsonProperty("suppliername")
    @JSONField(name = "suppliername")
    @ApiModelProperty("供应商名称")
    private String supplierName;

    /**
     * 更新人
     */
    @JsonProperty("updateby")
    @JSONField(name = "updateby")
    @ApiModelProperty("更新人")
    private String updateBy;

    /**
     * 更新时间
     */
    @JsonProperty("updatetime")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatetime" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("更新时间")
    private Timestamp updateTime;


    /**
     * 设置 [地址]
     */
    public void setAddress(String address) {
        this.address = address;
        this.modify("address", address);
    }

    /**
     * 设置 [邮箱]
     */
    public void setEMail(String eMail) {
        this.eMail = eMail;
        this.modify("email", eMail);
    }

    /**
     * 设置 [供应商名称]
     */
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
        this.modify("suppliername", supplierName);
    }


}
