package cn.ibizlab.demoapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.*;
import lombok.experimental.Accessors;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 服务DTO对象[IBIZOrderDTO]
 */
@Getter
@Setter
@NoArgsConstructor
@ApiModel("订单")
public class IBIZOrderDTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 总计
     */
    @JsonProperty("amount")
    @JSONField(name = "amount")
    @ApiModelProperty("总计")
    private BigDecimal amount;

    /**
     * 建立时间
     */
    @JsonProperty("createdate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createdate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("建立时间")
    private Timestamp createDate;

    /**
     * 建立人
     */
    @JsonProperty("createman")
    @JSONField(name = "createman")
    @ApiModelProperty("建立人")
    private String createMan;

    /**
     * 明细数
     */
    @JsonProperty("detailnum")
    @JSONField(name = "detailnum")
    @ApiModelProperty("明细数")
    private Integer detailNum;

    /**
     * 订单结束时间
     */
    @JsonProperty("endtime")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "endtime" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("订单结束时间")
    private Timestamp endTime;

    /**
     * 客户标识
     */
    @JsonProperty("ibizcustomerid")
    @JSONField(name = "ibizcustomerid")
    @ApiModelProperty("客户标识")
    private String ibizCustomerId;

    /**
     * 客户名称
     */
    @JsonProperty("ibizcustomername")
    @JSONField(name = "ibizcustomername")
    @ApiModelProperty("客户名称")
    private String ibizCustomerName;

    /**
     * 订单标识
     */
    @JsonProperty("ibizorderid")
    @JSONField(name = "ibizorderid")
    @ApiModelProperty("订单标识")
    private String ibizOrderId;

    /**
     * 订单名称
     */
    @JsonProperty("ibizordername")
    @JSONField(name = "ibizordername")
    @ApiModelProperty("订单名称")
    private String ibizOrderName;

    /**
     * 备注
     */
    @JsonProperty("memo")
    @JSONField(name = "memo")
    @ApiModelProperty("备注")
    private String memo;

    /**
     * 审批意见
     */
    @JsonProperty("opinion")
    @JSONField(name = "opinion")
    @ApiModelProperty("审批意见")
    private String opinion;

    /**
     * 订单状态
     */
    @JsonProperty("orderstate")
    @JSONField(name = "orderstate")
    @ApiModelProperty("订单状态")
    private String orderState;

    /**
     * 订单时间
     */
    @JsonProperty("ordertime")
    @JsonFormat(pattern = "yyyy-MM-dd", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "ordertime" , format = "yyyy-MM-dd")
    @ApiModelProperty("订单时间")
    private Timestamp orderTime;

    /**
     * 订单类型
     */
    @JsonProperty("ordertype")
    @JSONField(name = "ordertype")
    @ApiModelProperty("订单类型")
    private String orderType;

    /**
     * 订单编号
     */
    @JsonProperty("orderuid")
    @JSONField(name = "orderuid")
    @ApiModelProperty("订单编号")
    private String orderUid;

    /**
     * 订单开始时间
     */
    @JsonProperty("starttime")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "starttime" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("订单开始时间")
    private Timestamp startTime;

    /**
     * 图片
     */
    @JsonProperty("tp")
    @JSONField(name = "tp")
    @ApiModelProperty("图片")
    private String tp;

    /**
     * 更新时间
     */
    @JsonProperty("updatedate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatedate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("更新时间")
    private Timestamp updateDate;

    /**
     * 更新人
     */
    @JsonProperty("updateman")
    @JSONField(name = "updateman")
    @ApiModelProperty("更新人")
    private String updateMan;

    /**
     * 工作流实例
     */
    @JsonProperty("wfinstanceid")
    @JSONField(name = "wfinstanceid")
    @ApiModelProperty("工作流实例")
    private String wfInstanceId;

    /**
     * 工作流状态
     */
    @JsonProperty("wfstate")
    @JSONField(name = "wfstate")
    @ApiModelProperty("工作流状态")
    private Integer wfState;

    /**
     * 工作流步骤
     */
    @JsonProperty("wfstep")
    @JSONField(name = "wfstep")
    @ApiModelProperty("工作流步骤")
    private String wfStep;


    /**
     * 设置 [总计]
     */
    public void setAmount(BigDecimal amount) {
        this.amount = amount;
        this.modify("amount", amount);
    }

    /**
     * 设置 [明细数]
     */
    public void setDetailNum(Integer detailNum) {
        this.detailNum = detailNum;
        this.modify("detailnum", detailNum);
    }

    /**
     * 设置 [订单结束时间]
     */
    public void setEndTime(Timestamp endTime) {
        this.endTime = endTime;
        this.modify("endtime", endTime);
    }

    /**
     * 设置 [客户标识]
     */
    public void setIbizCustomerId(String ibizCustomerId) {
        this.ibizCustomerId = ibizCustomerId;
        this.modify("ibizcustomerid", ibizCustomerId);
    }

    /**
     * 设置 [客户名称]
     */
    public void setIbizCustomerName(String ibizCustomerName) {
        this.ibizCustomerName = ibizCustomerName;
        this.modify("ibizcustomername", ibizCustomerName);
    }

    /**
     * 设置 [订单名称]
     */
    public void setIbizOrderName(String ibizOrderName) {
        this.ibizOrderName = ibizOrderName;
        this.modify("ibizordername", ibizOrderName);
    }

    /**
     * 设置 [备注]
     */
    public void setMemo(String memo) {
        this.memo = memo;
        this.modify("memo", memo);
    }

    /**
     * 设置 [审批意见]
     */
    public void setOpinion(String opinion) {
        this.opinion = opinion;
        this.modify("opinion", opinion);
    }

    /**
     * 设置 [订单状态]
     */
    public void setOrderState(String orderState) {
        this.orderState = orderState;
        this.modify("orderstate", orderState);
    }

    /**
     * 设置 [订单时间]
     */
    public void setOrderTime(Timestamp orderTime) {
        this.orderTime = orderTime;
        this.modify("ordertime", orderTime);
    }

    /**
     * 设置 [订单类型]
     */
    public void setOrderType(String orderType) {
        this.orderType = orderType;
        this.modify("ordertype", orderType);
    }

    /**
     * 设置 [订单编号]
     */
    public void setOrderUid(String orderUid) {
        this.orderUid = orderUid;
        this.modify("orderuid", orderUid);
    }

    /**
     * 设置 [订单开始时间]
     */
    public void setStartTime(Timestamp startTime) {
        this.startTime = startTime;
        this.modify("starttime", startTime);
    }

    /**
     * 设置 [图片]
     */
    public void setTp(String tp) {
        this.tp = tp;
        this.modify("tp", tp);
    }

    /**
     * 设置 [工作流实例]
     */
    public void setWfInstanceId(String wfInstanceId) {
        this.wfInstanceId = wfInstanceId;
        this.modify("wfinstanceid", wfInstanceId);
    }

    /**
     * 设置 [工作流状态]
     */
    public void setWfState(Integer wfState) {
        this.wfState = wfState;
        this.modify("wfstate", wfState);
    }

    /**
     * 设置 [工作流步骤]
     */
    public void setWfStep(String wfStep) {
        this.wfStep = wfStep;
        this.modify("wfstep", wfStep);
    }


}
