package cn.ibizlab.core.sample.service.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Map;
import java.util.HashSet;
import java.util.HashMap;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.math.BigInteger;
import lombok.extern.slf4j.Slf4j;

import cn.ibizlab.util.security.SpringContextHolder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Service;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.Assert;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import cn.ibizlab.util.errors.BadRequestAlertException;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.context.annotation.Lazy;
import cn.ibizlab.core.sample.domain.IBIZSupplier;
import cn.ibizlab.core.sample.filter.IBIZSupplierSearchContext;
import cn.ibizlab.core.sample.service.IBIZSupplierService;
import cn.ibizlab.core.sample.mapper.IBIZSupplierMapper;
import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.security.AuthenticationUser;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.conditions.Wrapper;


/**
 * 实体[供货商] 服务对象接口实现
 */
@Slf4j
@Service("IBIZSupplierService")
public class IBIZSupplierServiceBase extends ServiceImpl<IBIZSupplierMapper,IBIZSupplier> implements IBIZSupplierService {


    protected int batchSize = 500;

    public IBIZSupplier get(IBIZSupplier et) {
        IBIZSupplier rt = this.baseMapper.selectEntity(et);
        Assert.notNull(rt,"数据不存在,供货商:"+et.getSupplierId());
        BeanUtils.copyProperties(rt, et);
        return et;
    }
    
    public List<IBIZSupplier> getByEntities(List<IBIZSupplier> entities) {
        return this.baseMapper.selectEntities(entities);
    }


    public IBIZSupplier getDraft(IBIZSupplier et) {
        return et;
    }

    public Integer checkKey(IBIZSupplier et) {
        return ( (!ObjectUtils.isEmpty(et.getSupplierId())) && this.count(Wrappers.<IBIZSupplier>query().eq("supplierid", et.getSupplierId()))>0 )?1:0;
    }

    @Override
    @Transactional
    public boolean create(IBIZSupplier et) {
        if(!this.retBool(this.baseMapper.insert(et))) 
            return false;
        get(et);
        return true;
    }
    @Transactional
    public boolean createBatch(List<IBIZSupplier> list) {
        this.saveBatch(list, batchSize);
        return true;
    }

    @Transactional
    public boolean update(IBIZSupplier et) {
        UpdateWrapper qw=et.getUpdateWrapper(true);
        qw.eq("supplierid", et.getSupplierId());
        if(!update(et, qw)) {
            return false;
        }
        get(et);
        return true;
    }

    @Transactional
    public boolean updateBatch(List<IBIZSupplier> list) {
        updateBatchById(list, batchSize);
        return true;
    }

    @Transactional
    public boolean save(IBIZSupplier et) {
        if(checkKey(et)>0)
            return getSelf().update(et);
        else
            return getSelf().create(et);
    }

    @Transactional
    public boolean saveBatch(List<IBIZSupplier> list) {
        List<IBIZSupplier> rt=this.getByEntities(list);
        Set<Serializable> keys=new HashSet<>();
        rt.forEach(et->{
            Serializable key = et.getSupplierId();
            if(!ObjectUtils.isEmpty(key))
                keys.add(key);
        });
        List<IBIZSupplier> _create=new ArrayList<>();
        List<IBIZSupplier> _update=new ArrayList<>();
        list.forEach(et-> {
            Serializable key = et.getSupplierId();
            if(keys.contains(key))
                _update.add(et);
            else
                _create.add(et);
        });
        List rtList=new ArrayList<>();
        if(_update.size()>0 && (!getSelf().updateBatch(_update)))
            return false;
        if(_create.size()>0 && (!getSelf().createBatch(_create)))
            return false;
        return true;
    }

    @Transactional
    public boolean remove(IBIZSupplier et) {
        String key = et.getSupplierId();

        if(!remove(new QueryWrapper<IBIZSupplier>()
                .eq("supplierid", et.getSupplierId())
            )) {
            return false;
        }
        return true ;
    }

    @Transactional
    public boolean removeByEntities(List<IBIZSupplier> entities) {
        this.baseMapper.deleteEntities(entities);
        return true;
    }

    public Page<IBIZSupplier> searchDefault(IBIZSupplierSearchContext context) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<IBIZSupplier> pages=baseMapper.searchDefault(context.getPages(),context,context.getSelectCond());
        return new PageImpl<IBIZSupplier>(pages.getRecords(), context.getPageable(), pages.getTotal());
    }
    public List<IBIZSupplier> listDefault(IBIZSupplierSearchContext context) {
        return baseMapper.listDefault(context,context.getSelectCond());
    }





    }