package cn.ibizlab.core.sample.service.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Map;
import java.util.HashSet;
import java.util.HashMap;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.math.BigInteger;
import lombok.extern.slf4j.Slf4j;

import cn.ibizlab.util.security.SpringContextHolder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Service;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.Assert;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import cn.ibizlab.util.errors.BadRequestAlertException;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.context.annotation.Lazy;
import cn.ibizlab.core.sample.domain.IBIZSample0016;
import cn.ibizlab.core.sample.filter.IBIZSample0016SearchContext;
import cn.ibizlab.core.sample.service.IBIZSample0016Service;
import cn.ibizlab.core.sample.mapper.IBIZSample0016Mapper;
import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.security.AuthenticationUser;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import cn.ibizlab.core.sample.domain.IBIZSample0014;
import cn.ibizlab.core.sample.service.IBIZSample0014Service;
import cn.ibizlab.core.sample.domain.IBIZSample0015;
import cn.ibizlab.core.sample.service.IBIZSample0015Service;


/**
 * 实体[项目成员] 服务对象接口实现
 */
@Slf4j
@Service("IBIZSample0016Service")
public class IBIZSample0016ServiceBase extends ServiceImpl<IBIZSample0016Mapper,IBIZSample0016> implements IBIZSample0016Service {

    @Autowired
    @Lazy
    protected IBIZSample0014Service ibizSample0014Service;
   
    @Autowired
    @Lazy
    protected IBIZSample0015Service ibizSample0015Service;
   

    protected int batchSize = 500;

    public IBIZSample0016 get(IBIZSample0016 et) {
        IBIZSample0016 rt = this.baseMapper.selectEntity(et);
        Assert.notNull(rt,"数据不存在,项目成员:"+et.getIbizSample0016Id());
        BeanUtils.copyProperties(rt, et);
        return et;
    }
    
    public List<IBIZSample0016> getByEntities(List<IBIZSample0016> entities) {
        return this.baseMapper.selectEntities(entities);
    }

    public void fillParentData(IBIZSample0016 et) {
        if(!ObjectUtils.isEmpty(et.getIbizSample0014Id())) {
            IBIZSample0014 ibizSample0014 = et.getIbizsample0014();
            if(!ObjectUtils.isEmpty(ibizSample0014)) {
                et.setIbizSample0014Name(ibizSample0014.getIbizSample0014Name());   
            }
        }    
        if(!ObjectUtils.isEmpty(et.getIbizSample0015Id())) {
            IBIZSample0015 ibizSample0015 = et.getIbizsample0015();
            if(!ObjectUtils.isEmpty(ibizSample0015)) {
                et.setIbizSample0015Name(ibizSample0015.getIbizSample0015Name());   
            }
        }    
    }

    public IBIZSample0016 getDraft(IBIZSample0016 et) {
        fillParentData(et);
        return et;
    }

    public Integer checkKey(IBIZSample0016 et) {
        return ( (!ObjectUtils.isEmpty(et.getIbizSample0016Id())) && this.count(Wrappers.<IBIZSample0016>query().eq("ibizsample0016id", et.getIbizSample0016Id()))>0 )?1:0;
    }

    @Override
    @Transactional
    public boolean create(IBIZSample0016 et) {
        if(!this.retBool(this.baseMapper.insert(et))) 
            return false;
        get(et);
        return true;
    }
    @Transactional
    public boolean createBatch(List<IBIZSample0016> list) {
        this.saveBatch(list, batchSize);
        return true;
    }

    @Transactional
    public boolean update(IBIZSample0016 et) {
        UpdateWrapper qw=et.getUpdateWrapper(true);
        qw.eq("ibizsample0016id", et.getIbizSample0016Id());
        if(!update(et, qw)) {
            return false;
        }
        get(et);
        return true;
    }

    @Transactional
    public boolean updateBatch(List<IBIZSample0016> list) {
        updateBatchById(list, batchSize);
        return true;
    }

    @Transactional
    public boolean save(IBIZSample0016 et) {
        if(checkKey(et)>0)
            return getSelf().update(et);
        else
            return getSelf().create(et);
    }

    @Transactional
    public boolean saveBatch(List<IBIZSample0016> list) {
        List<IBIZSample0016> rt=this.getByEntities(list);
        Set<Serializable> keys=new HashSet<>();
        rt.forEach(et->{
            Serializable key = et.getIbizSample0016Id();
            if(!ObjectUtils.isEmpty(key))
                keys.add(key);
        });
        List<IBIZSample0016> _create=new ArrayList<>();
        List<IBIZSample0016> _update=new ArrayList<>();
        list.forEach(et-> {
            Serializable key = et.getIbizSample0016Id();
            if(keys.contains(key))
                _update.add(et);
            else
                _create.add(et);
        });
        List rtList=new ArrayList<>();
        if(_update.size()>0 && (!getSelf().updateBatch(_update)))
            return false;
        if(_create.size()>0 && (!getSelf().createBatch(_create)))
            return false;
        return true;
    }

    @Transactional
    public boolean remove(IBIZSample0016 et) {
        String key = et.getIbizSample0016Id();

        if(!remove(new QueryWrapper<IBIZSample0016>()
                .eq("ibizsample0016id", et.getIbizSample0016Id())
            )) {
            return false;
        }
        return true ;
    }

    @Transactional
    public boolean removeByEntities(List<IBIZSample0016> entities) {
        this.baseMapper.deleteEntities(entities);
        return true;
    }

    public Page<IBIZSample0016> searchDefault(IBIZSample0016SearchContext context) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<IBIZSample0016> pages=baseMapper.searchDefault(context.getPages(),context,context.getSelectCond());
        return new PageImpl<IBIZSample0016>(pages.getRecords(), context.getPageable(), pages.getTotal());
    }
    public List<IBIZSample0016> listDefault(IBIZSample0016SearchContext context) {
        return baseMapper.listDefault(context,context.getSelectCond());
    }

    public List<IBIZSample0016> selectByIbizSample0014Id(String ibizSample0014Id) {
        return baseMapper.selectByIbizSample0014Id(ibizSample0014Id);
    }

    public boolean removeByIbizSample0014Id(String ibizSample0014Id) {
        return this.remove(new QueryWrapper<IBIZSample0016>().eq("ibizsample0014id",ibizSample0014Id));
    }

    public boolean resetByIbizSample0014Id(String ibizSample0014Id) {
        return this.update(new UpdateWrapper<IBIZSample0016>().set("ibizsample0014id",null).eq("ibizsample0014id",ibizSample0014Id));
    }

    public boolean saveByIbizsample0014(IBIZSample0014 ibizSample0014,List<IBIZSample0016> list) {
        if(list==null)
            return true;
        Set<String> delIds=new HashSet<String>();
        List<IBIZSample0016> _update=new ArrayList<IBIZSample0016>();
        List<IBIZSample0016> _create=new ArrayList<IBIZSample0016>();
        for(IBIZSample0016 before:selectByIbizSample0014Id(ibizSample0014.getIbizSample0014Id())){
            delIds.add(before.getIbizSample0016Id());
        }
        for(IBIZSample0016 sub:list) {
            sub.setIbizSample0014Id(ibizSample0014.getIbizSample0014Id());
            sub.setIbizsample0014(ibizSample0014);
            if(ObjectUtils.isEmpty(sub.getIbizSample0016Id()))
                sub.setIbizSample0016Id((String)sub.getDefaultKey(true));
            if(delIds.contains(sub.getIbizSample0016Id())) {
                delIds.remove(sub.getIbizSample0016Id());
                _update.add(sub);
            }
            else
                _create.add(sub);
        }
        if(_update.size()>0 && (!getSelf().updateBatch(_update)))
            return false;
        if(_create.size()>0 && (!getSelf().createBatch(_create)))
            return false;
        if(delIds.size()>0 && (!getSelf().removeBatch(delIds)))
            return false;
        return true;
    }

    public List<IBIZSample0016> selectByIbizSample0015Id(String ibizSample0015Id) {
        return baseMapper.selectByIbizSample0015Id(ibizSample0015Id);
    }

    public boolean removeByIbizSample0015Id(String ibizSample0015Id) {
        return this.remove(new QueryWrapper<IBIZSample0016>().eq("ibizsample0015id",ibizSample0015Id));
    }

    public boolean resetByIbizSample0015Id(String ibizSample0015Id) {
        return this.update(new UpdateWrapper<IBIZSample0016>().set("ibizsample0015id",null).eq("ibizsample0015id",ibizSample0015Id));
    }

    public boolean saveByIbizsample0015(IBIZSample0015 ibizSample0015,List<IBIZSample0016> list) {
        if(list==null)
            return true;
        Set<String> delIds=new HashSet<String>();
        List<IBIZSample0016> _update=new ArrayList<IBIZSample0016>();
        List<IBIZSample0016> _create=new ArrayList<IBIZSample0016>();
        for(IBIZSample0016 before:selectByIbizSample0015Id(ibizSample0015.getIbizSample0015Id())){
            delIds.add(before.getIbizSample0016Id());
        }
        for(IBIZSample0016 sub:list) {
            sub.setIbizSample0015Id(ibizSample0015.getIbizSample0015Id());
            sub.setIbizsample0015(ibizSample0015);
            if(ObjectUtils.isEmpty(sub.getIbizSample0016Id()))
                sub.setIbizSample0016Id((String)sub.getDefaultKey(true));
            if(delIds.contains(sub.getIbizSample0016Id())) {
                delIds.remove(sub.getIbizSample0016Id());
                _update.add(sub);
            }
            else
                _create.add(sub);
        }
        if(_update.size()>0 && (!getSelf().updateBatch(_update)))
            return false;
        if(_create.size()>0 && (!getSelf().createBatch(_create)))
            return false;
        if(delIds.size()>0 && (!getSelf().removeBatch(delIds)))
            return false;
        return true;
    }





    }