package cn.ibizlab.core.sample.service.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Map;
import java.util.HashSet;
import java.util.HashMap;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.math.BigInteger;
import lombok.extern.slf4j.Slf4j;

import cn.ibizlab.util.security.SpringContextHolder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Service;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.Assert;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import cn.ibizlab.util.errors.BadRequestAlertException;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.context.annotation.Lazy;
import cn.ibizlab.core.sample.domain.IBIZOrderType;
import cn.ibizlab.core.sample.filter.IBIZOrderTypeSearchContext;
import cn.ibizlab.core.sample.service.IBIZOrderTypeService;
import cn.ibizlab.core.sample.mapper.IBIZOrderTypeMapper;
import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.security.AuthenticationUser;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.conditions.Wrapper;


/**
 * 实体[订单类型] 服务对象接口实现
 */
@Slf4j
@Service("IBIZOrderTypeService")
public class IBIZOrderTypeServiceBase extends ServiceImpl<IBIZOrderTypeMapper,IBIZOrderType> implements IBIZOrderTypeService {


    protected int batchSize = 500;

    public IBIZOrderType get(IBIZOrderType et) {
        IBIZOrderType rt = this.baseMapper.selectEntity(et);
        Assert.notNull(rt,"数据不存在,订单类型:"+et.getIbizOrderTypeId());
        BeanUtils.copyProperties(rt, et);
        return et;
    }
    
    public List<IBIZOrderType> getByEntities(List<IBIZOrderType> entities) {
        return this.baseMapper.selectEntities(entities);
    }


    public IBIZOrderType getDraft(IBIZOrderType et) {
        return et;
    }

    public Integer checkKey(IBIZOrderType et) {
        return ( (!ObjectUtils.isEmpty(et.getIbizOrderTypeId())) && this.count(Wrappers.<IBIZOrderType>query().eq("ibizordertypeid", et.getIbizOrderTypeId()))>0 )?1:0;
    }

    @Override
    @Transactional
    public boolean create(IBIZOrderType et) {
        if(!this.retBool(this.baseMapper.insert(et))) 
            return false;
        get(et);
        return true;
    }
    @Transactional
    public boolean createBatch(List<IBIZOrderType> list) {
        this.saveBatch(list, batchSize);
        return true;
    }

    @Transactional
    public boolean update(IBIZOrderType et) {
        UpdateWrapper qw=et.getUpdateWrapper(true);
        qw.eq("ibizordertypeid", et.getIbizOrderTypeId());
        if(!update(et, qw)) {
            return false;
        }
        get(et);
        return true;
    }

    @Transactional
    public boolean updateBatch(List<IBIZOrderType> list) {
        updateBatchById(list, batchSize);
        return true;
    }

    @Transactional
    public boolean save(IBIZOrderType et) {
        if(checkKey(et)>0)
            return getSelf().update(et);
        else
            return getSelf().create(et);
    }

    @Transactional
    public boolean saveBatch(List<IBIZOrderType> list) {
        List<IBIZOrderType> rt=this.getByEntities(list);
        Set<Serializable> keys=new HashSet<>();
        rt.forEach(et->{
            Serializable key = et.getIbizOrderTypeId();
            if(!ObjectUtils.isEmpty(key))
                keys.add(key);
        });
        List<IBIZOrderType> _create=new ArrayList<>();
        List<IBIZOrderType> _update=new ArrayList<>();
        list.forEach(et-> {
            Serializable key = et.getIbizOrderTypeId();
            if(keys.contains(key))
                _update.add(et);
            else
                _create.add(et);
        });
        List rtList=new ArrayList<>();
        if(_update.size()>0 && (!getSelf().updateBatch(_update)))
            return false;
        if(_create.size()>0 && (!getSelf().createBatch(_create)))
            return false;
        return true;
    }

    @Transactional
    public boolean remove(IBIZOrderType et) {
        String key = et.getIbizOrderTypeId();

        if(!remove(new QueryWrapper<IBIZOrderType>()
                .eq("ibizordertypeid", et.getIbizOrderTypeId())
            )) {
            return false;
        }
        return true ;
    }

    @Transactional
    public boolean removeByEntities(List<IBIZOrderType> entities) {
        this.baseMapper.deleteEntities(entities);
        return true;
    }

    @Transactional
    public IBIZOrderType resetCodeList(IBIZOrderType dto) {
        return dto;
    }

    public Page<IBIZOrderType> searchDefault(IBIZOrderTypeSearchContext context) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<IBIZOrderType> pages=baseMapper.searchDefault(context.getPages(),context,context.getSelectCond());
        return new PageImpl<IBIZOrderType>(pages.getRecords(), context.getPageable(), pages.getTotal());
    }
    public List<IBIZOrderType> listDefault(IBIZOrderTypeSearchContext context) {
        return baseMapper.listDefault(context,context.getSelectCond());
    }





    }