package cn.ibizlab.core.sample.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import com.baomidou.mybatisplus.extension.service.IService;
import com.baomidou.dynamic.datasource.annotation.DS;
import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.security.SpringContextHolder;
import cn.ibizlab.core.sample.domain.IBIZUNIProduct;
import cn.ibizlab.core.sample.filter.IBIZUNIProductSearchContext;

public interface IBIZUNIProductService extends IService<IBIZUNIProduct> {

    default IBIZUNIProductService getSelf() {
        return SpringContextHolder.getBean(this.getClass());
    }

    IBIZUNIProduct get(IBIZUNIProduct et);
    default IBIZUNIProduct get(String key) {
        IBIZUNIProduct et = new IBIZUNIProduct();
        et.setIbizuniProductId(key);
        return getSelf().get(et);
    }
    default List<IBIZUNIProduct> getByIds(Collection<String> ids) {
        List<IBIZUNIProduct> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZUNIProduct et = new IBIZUNIProduct();
            et.setIbizuniProductId(key);
            entities.add(et);
        });
        return getSelf().getByEntities(entities);
    }
    List<IBIZUNIProduct> getByEntities(List<IBIZUNIProduct> entities);

    IBIZUNIProduct getDraft(IBIZUNIProduct et);

    Integer checkKey(IBIZUNIProduct et);

    boolean create(IBIZUNIProduct et);
    boolean createBatch(List<IBIZUNIProduct> list);

    boolean update(IBIZUNIProduct et);
    boolean updateBatch(List<IBIZUNIProduct> list);

    boolean save(IBIZUNIProduct et);
    boolean saveBatch(List<IBIZUNIProduct> list);

    default boolean remove(String key) {
        IBIZUNIProduct et = new IBIZUNIProduct();
        et.setIbizuniProductId(key);
        return getSelf().remove(et);
    }
    default boolean remove(List<String> key) {
        return removeBatch(key);
    }
    boolean remove(IBIZUNIProduct et);

    default boolean removeBatch(Collection<String> ids) {
        List<IBIZUNIProduct> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZUNIProduct et = new IBIZUNIProduct();
            et.setIbizuniProductId(key);
            entities.add(et);
        });
        return getSelf().removeByEntities(entities);
    }

    boolean removeByEntities(List<IBIZUNIProduct> entities);

    Page<IBIZUNIProduct> searchDefault(IBIZUNIProductSearchContext context);
    List<IBIZUNIProduct> listDefault(IBIZUNIProductSearchContext context);

}