package cn.ibizlab.core.sample.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import com.baomidou.mybatisplus.extension.service.IService;
import com.baomidou.dynamic.datasource.annotation.DS;
import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.security.SpringContextHolder;
import cn.ibizlab.core.sample.domain.IBIZTASK;
import cn.ibizlab.core.sample.filter.IBIZTASKSearchContext;
import cn.ibizlab.core.sample.domain.IBIZTASKTEAM;

public interface IBIZTASKService extends IService<IBIZTASK> {

    default IBIZTASKService getSelf() {
        return SpringContextHolder.getBean(this.getClass());
    }

    IBIZTASK get(IBIZTASK et);
    default IBIZTASK get(String key) {
        IBIZTASK et = new IBIZTASK();
        et.setIbiztaskid(key);
        return getSelf().get(et);
    }
    default List<IBIZTASK> getByIds(Collection<String> ids) {
        List<IBIZTASK> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZTASK et = new IBIZTASK();
            et.setIbiztaskid(key);
            entities.add(et);
        });
        return getSelf().getByEntities(entities);
    }
    List<IBIZTASK> getByEntities(List<IBIZTASK> entities);

    IBIZTASK getDraft(IBIZTASK et);

    Integer checkKey(IBIZTASK et);

    boolean create(IBIZTASK et);
    boolean createBatch(List<IBIZTASK> list);

    boolean update(IBIZTASK et);
    boolean updateBatch(List<IBIZTASK> list);

    boolean save(IBIZTASK et);
    boolean saveBatch(List<IBIZTASK> list);

    default boolean remove(String key) {
        IBIZTASK et = new IBIZTASK();
        et.setIbiztaskid(key);
        return getSelf().remove(et);
    }
    default boolean remove(List<String> key) {
        return removeBatch(key);
    }
    boolean remove(IBIZTASK et);

    default boolean removeBatch(Collection<String> ids) {
        List<IBIZTASK> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZTASK et = new IBIZTASK();
            et.setIbiztaskid(key);
            entities.add(et);
        });
        return getSelf().removeByEntities(entities);
    }

    boolean removeByEntities(List<IBIZTASK> entities);

    default IBIZTASK createTemp(IBIZTASK dto) {
        return dto;
    }

    default IBIZTASK createTempMajor(IBIZTASK dto) {
        return dto;
    }

    default IBIZTASK updateTemp(IBIZTASK dto) {
        return dto;
    }

    default IBIZTASK updateTempMajor(IBIZTASK dto) {
        return dto;
    }

    default List<String> removeTemp(List<String> keys) {
        return keys;
    }

    default List<String> removeTempMajor(List<String> keys) {
        return keys;
    }

    default IBIZTASK getTemp(String key) {
        return null;
    }

    default IBIZTASK getTempMajor(String key) {
        return null;
    }

    default IBIZTASK getDraftTemp(IBIZTASK dto) {
        return null;
    }

    default IBIZTASK getDraftTempMajor(IBIZTASK dto) {
        return null;
    }

    Page<IBIZTASK> searchDefault(IBIZTASKSearchContext context);
    List<IBIZTASK> listDefault(IBIZTASKSearchContext context);

    List<IBIZTASKTEAM> getIbiztaskteam(IBIZTASK et);

}