package cn.ibizlab.core.sample.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import com.baomidou.mybatisplus.extension.service.IService;
import com.baomidou.dynamic.datasource.annotation.DS;
import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.security.SpringContextHolder;
import cn.ibizlab.core.sample.domain.IBIZSample0010;
import cn.ibizlab.core.sample.filter.IBIZSample0010SearchContext;

public interface IBIZSample0010Service extends IService<IBIZSample0010> {

    default IBIZSample0010Service getSelf() {
        return SpringContextHolder.getBean(this.getClass());
    }

    IBIZSample0010 get(IBIZSample0010 et);
    default IBIZSample0010 get(String key) {
        IBIZSample0010 et = new IBIZSample0010();
        et.setIbizSample0010Id(key);
        return getSelf().get(et);
    }
    default List<IBIZSample0010> getByIds(Collection<String> ids) {
        List<IBIZSample0010> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZSample0010 et = new IBIZSample0010();
            et.setIbizSample0010Id(key);
            entities.add(et);
        });
        return getSelf().getByEntities(entities);
    }
    List<IBIZSample0010> getByEntities(List<IBIZSample0010> entities);

    IBIZSample0010 getDraft(IBIZSample0010 et);

    Integer checkKey(IBIZSample0010 et);

    boolean create(IBIZSample0010 et);
    boolean createBatch(List<IBIZSample0010> list);

    boolean update(IBIZSample0010 et);
    boolean updateBatch(List<IBIZSample0010> list);

    boolean save(IBIZSample0010 et);
    boolean saveBatch(List<IBIZSample0010> list);

    default boolean remove(String key) {
        IBIZSample0010 et = new IBIZSample0010();
        et.setIbizSample0010Id(key);
        return getSelf().remove(et);
    }
    default boolean remove(List<String> key) {
        return removeBatch(key);
    }
    boolean remove(IBIZSample0010 et);

    default boolean removeBatch(Collection<String> ids) {
        List<IBIZSample0010> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZSample0010 et = new IBIZSample0010();
            et.setIbizSample0010Id(key);
            entities.add(et);
        });
        return getSelf().removeByEntities(entities);
    }

    boolean removeByEntities(List<IBIZSample0010> entities);

    Page<IBIZSample0010> searchDefault(IBIZSample0010SearchContext context);
    List<IBIZSample0010> listDefault(IBIZSample0010SearchContext context);

    default IBIZSample0010SearchContext getSearchContext() {
        return new IBIZSample0010SearchContext();
    }
}