package cn.ibizlab.core.sample.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import com.baomidou.mybatisplus.extension.service.IService;
import com.baomidou.dynamic.datasource.annotation.DS;
import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.security.SpringContextHolder;
import cn.ibizlab.core.sample.domain.IBIZSample0006;
import cn.ibizlab.core.sample.filter.IBIZSample0006SearchContext;

public interface IBIZSample0006Service extends IService<IBIZSample0006> {

    default IBIZSample0006Service getSelf() {
        return SpringContextHolder.getBean(this.getClass());
    }

    IBIZSample0006 get(IBIZSample0006 et);
    default IBIZSample0006 get(String key) {
        IBIZSample0006 et = new IBIZSample0006();
        et.setIbizSample0006Id(key);
        return getSelf().get(et);
    }
    default List<IBIZSample0006> getByIds(Collection<String> ids) {
        List<IBIZSample0006> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZSample0006 et = new IBIZSample0006();
            et.setIbizSample0006Id(key);
            entities.add(et);
        });
        return getSelf().getByEntities(entities);
    }
    List<IBIZSample0006> getByEntities(List<IBIZSample0006> entities);

    IBIZSample0006 getDraft(IBIZSample0006 et);

    Integer checkKey(IBIZSample0006 et);

    boolean create(IBIZSample0006 et);
    boolean createBatch(List<IBIZSample0006> list);

    boolean update(IBIZSample0006 et);
    boolean updateBatch(List<IBIZSample0006> list);

    boolean save(IBIZSample0006 et);
    boolean saveBatch(List<IBIZSample0006> list);

    default boolean remove(String key) {
        IBIZSample0006 et = new IBIZSample0006();
        et.setIbizSample0006Id(key);
        return getSelf().remove(et);
    }
    default boolean remove(List<String> key) {
        return removeBatch(key);
    }
    boolean remove(IBIZSample0006 et);

    default boolean removeBatch(Collection<String> ids) {
        List<IBIZSample0006> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZSample0006 et = new IBIZSample0006();
            et.setIbizSample0006Id(key);
            entities.add(et);
        });
        return getSelf().removeByEntities(entities);
    }

    boolean removeByEntities(List<IBIZSample0006> entities);

    Page<IBIZSample0006> searchDefault(IBIZSample0006SearchContext context);
    List<IBIZSample0006> listDefault(IBIZSample0006SearchContext context);

}