package cn.ibizlab.core.sample.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import com.baomidou.mybatisplus.extension.service.IService;
import com.baomidou.dynamic.datasource.annotation.DS;
import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.security.SpringContextHolder;
import cn.ibizlab.core.sample.domain.IBIZSample0004;
import cn.ibizlab.core.sample.filter.IBIZSample0004SearchContext;

public interface IBIZSample0004Service extends IService<IBIZSample0004> {

    default IBIZSample0004Service getSelf() {
        return SpringContextHolder.getBean(this.getClass());
    }

    IBIZSample0004 get(IBIZSample0004 et);
    default IBIZSample0004 get(String key) {
        IBIZSample0004 et = new IBIZSample0004();
        et.setIbizSample0004Id(key);
        return getSelf().get(et);
    }
    default List<IBIZSample0004> getByIds(Collection<String> ids) {
        List<IBIZSample0004> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZSample0004 et = new IBIZSample0004();
            et.setIbizSample0004Id(key);
            entities.add(et);
        });
        return getSelf().getByEntities(entities);
    }
    List<IBIZSample0004> getByEntities(List<IBIZSample0004> entities);

    IBIZSample0004 getDraft(IBIZSample0004 et);

    Integer checkKey(IBIZSample0004 et);

    boolean create(IBIZSample0004 et);
    boolean createBatch(List<IBIZSample0004> list);

    boolean update(IBIZSample0004 et);
    boolean updateBatch(List<IBIZSample0004> list);

    boolean save(IBIZSample0004 et);
    boolean saveBatch(List<IBIZSample0004> list);

    default boolean remove(String key) {
        IBIZSample0004 et = new IBIZSample0004();
        et.setIbizSample0004Id(key);
        return getSelf().remove(et);
    }
    default boolean remove(List<String> key) {
        return removeBatch(key);
    }
    boolean remove(IBIZSample0004 et);

    default boolean removeBatch(Collection<String> ids) {
        List<IBIZSample0004> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZSample0004 et = new IBIZSample0004();
            et.setIbizSample0004Id(key);
            entities.add(et);
        });
        return getSelf().removeByEntities(entities);
    }

    boolean removeByEntities(List<IBIZSample0004> entities);

    Page<IBIZSample0004> searchDefault(IBIZSample0004SearchContext context);
    List<IBIZSample0004> listDefault(IBIZSample0004SearchContext context);

}