package cn.ibizlab.core.sample.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import com.baomidou.mybatisplus.extension.service.IService;
import com.baomidou.dynamic.datasource.annotation.DS;
import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.security.SpringContextHolder;
import cn.ibizlab.core.sample.domain.IBIZSample0003;
import cn.ibizlab.core.sample.filter.IBIZSample0003SearchContext;

public interface IBIZSample0003Service extends IService<IBIZSample0003> {

    default IBIZSample0003Service getSelf() {
        return SpringContextHolder.getBean(this.getClass());
    }

    IBIZSample0003 get(IBIZSample0003 et);
    default IBIZSample0003 get(String key) {
        IBIZSample0003 et = new IBIZSample0003();
        et.setIbizsample0003Id(key);
        return getSelf().get(et);
    }
    default List<IBIZSample0003> getByIds(Collection<String> ids) {
        List<IBIZSample0003> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZSample0003 et = new IBIZSample0003();
            et.setIbizsample0003Id(key);
            entities.add(et);
        });
        return getSelf().getByEntities(entities);
    }
    List<IBIZSample0003> getByEntities(List<IBIZSample0003> entities);

    IBIZSample0003 getDraft(IBIZSample0003 et);

    Integer checkKey(IBIZSample0003 et);

    boolean create(IBIZSample0003 et);
    boolean createBatch(List<IBIZSample0003> list);

    boolean update(IBIZSample0003 et);
    boolean updateBatch(List<IBIZSample0003> list);

    boolean save(IBIZSample0003 et);
    boolean saveBatch(List<IBIZSample0003> list);

    default boolean remove(String key) {
        IBIZSample0003 et = new IBIZSample0003();
        et.setIbizsample0003Id(key);
        return getSelf().remove(et);
    }
    default boolean remove(List<String> key) {
        return removeBatch(key);
    }
    boolean remove(IBIZSample0003 et);

    default boolean removeBatch(Collection<String> ids) {
        List<IBIZSample0003> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZSample0003 et = new IBIZSample0003();
            et.setIbizsample0003Id(key);
            entities.add(et);
        });
        return getSelf().removeByEntities(entities);
    }

    boolean removeByEntities(List<IBIZSample0003> entities);

    Page<IBIZSample0003> searchCurData(IBIZSample0003SearchContext context);
    List<IBIZSample0003> listCurData(IBIZSample0003SearchContext context);

    Page<IBIZSample0003> searchDefault(IBIZSample0003SearchContext context);
    List<IBIZSample0003> listDefault(IBIZSample0003SearchContext context);

    Page<IBIZSample0003> searchTopData(IBIZSample0003SearchContext context);
    List<IBIZSample0003> listTopData(IBIZSample0003SearchContext context);

    List<IBIZSample0003> selectByPibizsample0003id(String pibizsample0003id);
    boolean removeByPibizsample0003id(String pibizsample0003id);
    boolean resetByPibizsample0003id(String pibizsample0003id);
    boolean saveByPibizsample0003(cn.ibizlab.core.sample.domain.IBIZSample0003 ibizSample0003,List<IBIZSample0003> list);
    default boolean saveByPibizsample0003id(String pibizsample0003id,List<IBIZSample0003> list) {
        cn.ibizlab.core.sample.domain.IBIZSample0003 et = new cn.ibizlab.core.sample.domain.IBIZSample0003();
        et.setIbizsample0003Id(pibizsample0003id);
        return getSelf().saveByPibizsample0003(et,list);
    }

}