package cn.ibizlab.core.sample.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import com.baomidou.mybatisplus.extension.service.IService;
import com.baomidou.dynamic.datasource.annotation.DS;
import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.security.SpringContextHolder;
import cn.ibizlab.core.sample.domain.IBIZCustomer_INTF;
import cn.ibizlab.core.sample.filter.IBIZCustomer_INTFSearchContext;

public interface IBIZCustomer_INTFService extends IService<IBIZCustomer_INTF> {

    default IBIZCustomer_INTFService getSelf() {
        return SpringContextHolder.getBean(this.getClass());
    }

    IBIZCustomer_INTF get(IBIZCustomer_INTF et);
    default IBIZCustomer_INTF get(String key) {
        IBIZCustomer_INTF et = new IBIZCustomer_INTF();
        et.setIbizCustomerId(key);
        return getSelf().get(et);
    }
    default List<IBIZCustomer_INTF> getByIds(Collection<String> ids) {
        List<IBIZCustomer_INTF> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZCustomer_INTF et = new IBIZCustomer_INTF();
            et.setIbizCustomerId(key);
            entities.add(et);
        });
        return getSelf().getByEntities(entities);
    }
    List<IBIZCustomer_INTF> getByEntities(List<IBIZCustomer_INTF> entities);

    IBIZCustomer_INTF getDraft(IBIZCustomer_INTF et);

    Integer checkKey(IBIZCustomer_INTF et);

    boolean create(IBIZCustomer_INTF et);
    boolean createBatch(List<IBIZCustomer_INTF> list);

    boolean update(IBIZCustomer_INTF et);
    boolean updateBatch(List<IBIZCustomer_INTF> list);

    boolean save(IBIZCustomer_INTF et);
    boolean saveBatch(List<IBIZCustomer_INTF> list);

    default boolean remove(String key) {
        IBIZCustomer_INTF et = new IBIZCustomer_INTF();
        et.setIbizCustomerId(key);
        return getSelf().remove(et);
    }
    default boolean remove(List<String> key) {
        return removeBatch(key);
    }
    boolean remove(IBIZCustomer_INTF et);

    default boolean removeBatch(Collection<String> ids) {
        List<IBIZCustomer_INTF> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZCustomer_INTF et = new IBIZCustomer_INTF();
            et.setIbizCustomerId(key);
            entities.add(et);
        });
        return getSelf().removeByEntities(entities);
    }

    boolean removeByEntities(List<IBIZCustomer_INTF> entities);

    default IBIZCustomer_INTF xxx(IBIZCustomer_INTF dto) {
        return dto;
    }

    Page<IBIZCustomer_INTF> searchCurCustomer(IBIZCustomer_INTFSearchContext context);
    List<IBIZCustomer_INTF> listCurCustomer(IBIZCustomer_INTFSearchContext context);

    Page<IBIZCustomer_INTF> searchDefault(IBIZCustomer_INTFSearchContext context);
    List<IBIZCustomer_INTF> listDefault(IBIZCustomer_INTFSearchContext context);

}