package cn.ibizlab.core.sample.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import com.baomidou.mybatisplus.extension.service.IService;
import com.baomidou.dynamic.datasource.annotation.DS;
import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.security.SpringContextHolder;
import cn.ibizlab.core.sample.domain.DYNADASHBOARD;
import cn.ibizlab.core.sample.filter.DYNADASHBOARDSearchContext;

public interface DYNADASHBOARDService extends IService<DYNADASHBOARD> {

    default DYNADASHBOARDService getSelf() {
        return SpringContextHolder.getBean(this.getClass());
    }

    DYNADASHBOARD get(DYNADASHBOARD et);
    default DYNADASHBOARD get(String key) {
        DYNADASHBOARD et = new DYNADASHBOARD();
        et.setDynadashboardid(key);
        return getSelf().get(et);
    }
    default List<DYNADASHBOARD> getByIds(Collection<String> ids) {
        List<DYNADASHBOARD> entities =new ArrayList();
        ids.forEach(key -> {
            DYNADASHBOARD et = new DYNADASHBOARD();
            et.setDynadashboardid(key);
            entities.add(et);
        });
        return getSelf().getByEntities(entities);
    }
    List<DYNADASHBOARD> getByEntities(List<DYNADASHBOARD> entities);

    DYNADASHBOARD getDraft(DYNADASHBOARD et);

    Integer checkKey(DYNADASHBOARD et);

    boolean create(DYNADASHBOARD et);
    boolean createBatch(List<DYNADASHBOARD> list);

    boolean update(DYNADASHBOARD et);
    boolean updateBatch(List<DYNADASHBOARD> list);

    boolean save(DYNADASHBOARD et);
    boolean saveBatch(List<DYNADASHBOARD> list);

    default boolean remove(String key) {
        DYNADASHBOARD et = new DYNADASHBOARD();
        et.setDynadashboardid(key);
        return getSelf().remove(et);
    }
    default boolean remove(List<String> key) {
        return removeBatch(key);
    }
    boolean remove(DYNADASHBOARD et);

    default boolean removeBatch(Collection<String> ids) {
        List<DYNADASHBOARD> entities =new ArrayList();
        ids.forEach(key -> {
            DYNADASHBOARD et = new DYNADASHBOARD();
            et.setDynadashboardid(key);
            entities.add(et);
        });
        return getSelf().removeByEntities(entities);
    }

    boolean removeByEntities(List<DYNADASHBOARD> entities);

    Page<DYNADASHBOARD> searchDefault(DYNADASHBOARDSearchContext context);
    List<DYNADASHBOARD> listDefault(DYNADASHBOARDSearchContext context);

}