package cn.ibizlab.core.sample.domain;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.math.BigInteger;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import org.springframework.util.ObjectUtils;
import org.springframework.util.DigestUtils;
import org.springframework.util.Assert;
import cn.ibizlab.util.domain.EntityBase;
import cn.ibizlab.util.annotation.DEField;
import cn.ibizlab.util.enums.DEPredefinedFieldType;
import cn.ibizlab.util.enums.DEFieldDefaultValueType;
import cn.ibizlab.util.helper.DataObject;
import cn.ibizlab.util.annotation.Audit;
import cn.ibizlab.util.enums.DupCheck;
import cn.ibizlab.util.domain.EntityMP;
import java.io.Serializable;
import lombok.*;
import lombok.experimental.Accessors;
import org.springframework.data.annotation.Transient;
import org.springframework.data.annotation.Id;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.baomidou.mybatisplus.annotation.*;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import cn.ibizlab.core.sample.domain.IBIZSample0012;
import cn.ibizlab.core.sample.domain.IBIZUNIProduct;

@Getter
@Setter
@NoArgsConstructor
@JsonIgnoreProperties(value = "handler")
@TableName(value = "T_IBIZSAMPLE0013", resultMap = "IBIZSample0013ResultMap")
@ApiModel(value = "IBIZSAMPLE0013", description = "订单明细")
public class IBIZSample0013 extends EntityMP implements Serializable
{

    /**
     * 更新人
     */
    @TableField(value = "updateman")
    @DEField(name = "updateman" , preType = DEPredefinedFieldType.UPDATEMAN , dict = "SysOperator")
    @JsonProperty("updateman")
    @JSONField(name = "updateman")
    @ApiModelProperty(value = "updateman", notes = "更新人")
    private String updateMan;

    /**
     * 订单明细名称
     */
    @TableField(value = "ibizsample0013name")
    @DEField(name = "ibizsample0013name")
    @JsonProperty("ibizsample0013name")
    @JSONField(name = "ibizsample0013name")
    @ApiModelProperty(value = "ibizsample0013name", notes = "订单明细名称")
    private String ibizSample0013Name;

    /**
     * 更新时间
     */
    @TableField(value = "updatedate")
    @DEField(name = "updatedate" , preType = DEPredefinedFieldType.UPDATEDATE)
    @JsonProperty("updatedate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatedate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "updatedate", notes = "更新时间")
    private Timestamp updateDate;

    /**
     * 建立人
     */
    @TableField(value = "createman" , fill = FieldFill.INSERT)
    @DEField(name = "createman" , preType = DEPredefinedFieldType.CREATEMAN , dict = "SysOperator")
    @JsonProperty("createman")
    @JSONField(name = "createman")
    @ApiModelProperty(value = "createman", notes = "建立人")
    private String createMan;

    /**
     * 建立时间
     */
    @TableField(value = "createdate" , fill = FieldFill.INSERT)
    @DEField(name = "createdate" , preType = DEPredefinedFieldType.CREATEDATE)
    @JsonProperty("createdate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createdate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "createdate", notes = "建立时间")
    private Timestamp createDate;

    /**
     * 小计
     */
    @TableField(value = "amount" , exist = false)
    @DEField(name = "amount")
    @JsonProperty("amount")
    @JSONField(name = "amount")
    @ApiModelProperty(value = "amount", notes = "小计")
    private BigDecimal amount;

    /**
     * 数量
     */
    @TableField(value = "quantity")
    @DEField(name = "quantity")
    @JsonProperty("quantity")
    @JSONField(name = "quantity")
    @ApiModelProperty(value = "quantity", notes = "数量")
    private Integer quantity;

    /**
     * 订单明细标识
     */
    @Id
    @TableId(value = "ibizsample0013id" , type = IdType.ASSIGN_UUID)
    @DEField(name = "ibizsample0013id" , isKeyField = true)
    @JsonProperty("ibizsample0013id")
    @JSONField(name = "ibizsample0013id")
    @ApiModelProperty(value = "ibizsample0013id", notes = "订单明细标识")
    private String ibizSample0013Id;

    /**
     * 单位
     */
    @TableField(value = "unit" , exist = false)
    @DEField(name = "unit")
    @JsonProperty("unit")
    @JSONField(name = "unit")
    @ApiModelProperty(value = "unit", notes = "单位")
    private String unit;

    /**
     * 统一产品名称
     */
    @TableField(value = "ibizuniproductname" , exist = false)
    @DEField(name = "ibizuniproductname")
    @JsonProperty("ibizuniproductname")
    @JSONField(name = "ibizuniproductname")
    @ApiModelProperty(value = "ibizuniproductname", notes = "统一产品名称")
    private String ibizuniProductName;

    /**
     * 单价
     */
    @TableField(value = "unitprice" , exist = false)
    @DEField(name = "unitprice")
    @JsonProperty("unitprice")
    @JSONField(name = "unitprice")
    @ApiModelProperty(value = "unitprice", notes = "单价")
    private BigDecimal unitPrice;

    /**
     * 订单名称
     */
    @TableField(value = "ibizsample0012name" , exist = false)
    @DEField(name = "ibizsample0012name")
    @JsonProperty("ibizsample0012name")
    @JSONField(name = "ibizsample0012name")
    @ApiModelProperty(value = "ibizsample0012name", notes = "订单名称")
    private String ibizSample0012Name;

    /**
     * 统一产品标识
     */
    @TableField(value = "ibizuniproductid")
    @DEField(name = "ibizuniproductid")
    @JsonProperty("ibizuniproductid")
    @JSONField(name = "ibizuniproductid")
    @ApiModelProperty(value = "ibizuniproductid", notes = "统一产品标识")
    private String ibizuniProductId;

    /**
     * 订单标识
     */
    @TableField(value = "ibizsample0012id")
    @DEField(name = "ibizsample0012id")
    @JsonProperty("ibizsample0012id")
    @JSONField(name = "ibizsample0012id")
    @ApiModelProperty(value = "ibizsample0012id", notes = "订单标识")
    private String ibizSample0012Id;


    /**
     * 订单
     */
    @JsonIgnore
    @JSONField(serialize = false)
    @TableField(exist = false)
    @ApiModelProperty(value = "ibizsample0012", notes = "")
    private IBIZSample0012 ibizsample0012;
    /**
     * 统一产品（索引主实体）
     */
    @JsonIgnore
    @JSONField(serialize = false)
    @TableField(exist = false)
    @ApiModelProperty(value = "ibizuniproduct", notes = "")
    private IBIZUNIProduct ibizuniproduct;



    /**
     * 设置 [订单明细名称]
     */
    public void setIbizSample0013Name(String ibizSample0013Name) {
        this.ibizSample0013Name = ibizSample0013Name;
        this.modify("ibizsample0013name", ibizSample0013Name);
    }




    /**
     * 设置 [小计]
     */
    public void setAmount(BigDecimal amount) {
        this.amount = amount;
        this.modify("amount", amount);
    }

    /**
     * 设置 [数量]
     */
    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
        this.modify("quantity", quantity);
    }


    /**
     * 设置 [单位]
     */
    public void setUnit(String unit) {
        this.unit = unit;
        this.modify("unit", unit);
    }

    /**
     * 设置 [统一产品名称]
     */
    public void setIbizuniProductName(String ibizuniProductName) {
        this.ibizuniProductName = ibizuniProductName;
        this.modify("ibizuniproductname", ibizuniProductName);
    }

    /**
     * 设置 [单价]
     */
    public void setUnitPrice(BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
        this.modify("unitprice", unitPrice);
    }

    /**
     * 设置 [订单名称]
     */
    public void setIbizSample0012Name(String ibizSample0012Name) {
        this.ibizSample0012Name = ibizSample0012Name;
        this.modify("ibizsample0012name", ibizSample0012Name);
    }

    /**
     * 设置 [统一产品标识]
     */
    public void setIbizuniProductId(String ibizuniProductId) {
        this.ibizuniProductId = ibizuniProductId;
        this.modify("ibizuniproductid", ibizuniProductId);
    }

    /**
     * 设置 [订单标识]
     */
    public void setIbizSample0012Id(String ibizSample0012Id) {
        this.ibizSample0012Id = ibizSample0012Id;
        this.modify("ibizsample0012id", ibizSample0012Id);
    }



    

    /**
     * 复制当前对象数据到目标对象(粘贴重置)
     * @param targetEntity 目标数据对象
     * @param bIncEmpty  是否包括空值
     * @param <T>
     * @return
     */
    @Override
    public <T> T copyTo(T targetEntity, boolean bIncEmpty) {
        this.reset("ibizsample0013id");        
        return super.copyTo(targetEntity, bIncEmpty);
    }    
}