package cn.ibizlab.core.sample.domain;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.math.BigInteger;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import org.springframework.util.ObjectUtils;
import org.springframework.util.DigestUtils;
import org.springframework.util.Assert;
import cn.ibizlab.util.domain.EntityBase;
import cn.ibizlab.util.annotation.DEField;
import cn.ibizlab.util.enums.DEPredefinedFieldType;
import cn.ibizlab.util.enums.DEFieldDefaultValueType;
import cn.ibizlab.util.helper.DataObject;
import cn.ibizlab.util.annotation.Audit;
import cn.ibizlab.util.enums.DupCheck;
import cn.ibizlab.util.domain.EntityMP;
import java.io.Serializable;
import lombok.*;
import lombok.experimental.Accessors;
import org.springframework.data.annotation.Transient;
import org.springframework.data.annotation.Id;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.baomidou.mybatisplus.annotation.*;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;

@Getter
@Setter
@NoArgsConstructor
@JsonIgnoreProperties(value = "handler")
@TableName(value = "T_IBIZSAMPLE0009", resultMap = "IBIZSample0009ResultMap")
@ApiModel(value = "IBIZSAMPLE0009", description = "商品价格明细")
public class IBIZSample0009 extends EntityMP implements Serializable
{

    /**
     * 更新时间
     */
    @TableField(value = "updatedate")
    @DEField(name = "updatedate" , preType = DEPredefinedFieldType.UPDATEDATE)
    @JsonProperty("updatedate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatedate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "updatedate", notes = "更新时间")
    private Timestamp updateDate;

    /**
     * 日期
     */
    @TableField(value = "date")
    @DEField(name = "date")
    @JsonProperty("date")
    @JsonFormat(pattern = "yyyy-MM-dd", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "date" , format = "yyyy-MM-dd")
    @ApiModelProperty(value = "date", notes = "日期")
    private Timestamp date;

    /**
     * 建立人
     */
    @TableField(value = "createman" , fill = FieldFill.INSERT)
    @DEField(name = "createman" , preType = DEPredefinedFieldType.CREATEMAN , dict = "SysOperator")
    @JsonProperty("createman")
    @JSONField(name = "createman")
    @ApiModelProperty(value = "createman", notes = "建立人")
    private String createMan;

    /**
     * 收盘
     */
    @TableField(value = "sp")
    @DEField(name = "sp")
    @JsonProperty("sp")
    @JSONField(name = "sp")
    @ApiModelProperty(value = "sp", notes = "收盘")
    private BigDecimal sp;

    /**
     * 商品价格明细名称
     */
    @TableField(value = "ibizsample0009name")
    @DEField(name = "ibizsample0009name")
    @JsonProperty("ibizsample0009name")
    @JSONField(name = "ibizsample0009name")
    @ApiModelProperty(value = "ibizsample0009name", notes = "商品价格明细名称")
    private String ibizSample0009Name;

    /**
     * 商品价格明细标识
     */
    @Id
    @TableId(value = "ibizsample0009id" , type = IdType.ASSIGN_UUID)
    @DEField(name = "ibizsample0009id" , isKeyField = true)
    @JsonProperty("ibizsample0009id")
    @JSONField(name = "ibizsample0009id")
    @ApiModelProperty(value = "ibizsample0009id", notes = "商品价格明细标识")
    private String ibizSample0009Id;

    /**
     * 建立时间
     */
    @TableField(value = "createdate" , fill = FieldFill.INSERT)
    @DEField(name = "createdate" , preType = DEPredefinedFieldType.CREATEDATE)
    @JsonProperty("createdate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createdate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "createdate", notes = "建立时间")
    private Timestamp createDate;

    /**
     * 商品名称
     */
    @TableField(value = "spmc")
    @DEField(name = "spmc")
    @JsonProperty("spmc")
    @JSONField(name = "spmc")
    @ApiModelProperty(value = "spmc", notes = "商品名称")
    private String spmc;

    /**
     * 盘低
     */
    @TableField(value = "pd")
    @DEField(name = "pd")
    @JsonProperty("pd")
    @JSONField(name = "pd")
    @ApiModelProperty(value = "pd", notes = "盘低")
    private BigDecimal pd;

    /**
     * 统计
     */
    @TableField(value = "tj" , exist = false)
    @DEField(name = "tj")
    @JsonProperty("tj")
    @JSONField(name = "tj")
    @ApiModelProperty(value = "tj", notes = "统计")
    private String tj;

    /**
     * 更新人
     */
    @TableField(value = "updateman")
    @DEField(name = "updateman" , preType = DEPredefinedFieldType.UPDATEMAN , dict = "SysOperator")
    @JsonProperty("updateman")
    @JSONField(name = "updateman")
    @ApiModelProperty(value = "updateman", notes = "更新人")
    private String updateMan;

    /**
     * 盘高
     */
    @TableField(value = "pg")
    @DEField(name = "pg")
    @JsonProperty("pg")
    @JSONField(name = "pg")
    @ApiModelProperty(value = "pg", notes = "盘高")
    private BigDecimal pg;

    /**
     * 开盘
     */
    @TableField(value = "kp")
    @DEField(name = "kp")
    @JsonProperty("kp")
    @JSONField(name = "kp")
    @ApiModelProperty(value = "kp", notes = "开盘")
    private BigDecimal kp;





    /**
     * 设置 [日期]
     */
    public void setDate(Timestamp date) {
        this.date = date;
        this.modify("date", date);
    }


    /**
     * 设置 [收盘]
     */
    public void setSp(BigDecimal sp) {
        this.sp = sp;
        this.modify("sp", sp);
    }

    /**
     * 设置 [商品价格明细名称]
     */
    public void setIbizSample0009Name(String ibizSample0009Name) {
        this.ibizSample0009Name = ibizSample0009Name;
        this.modify("ibizsample0009name", ibizSample0009Name);
    }



    /**
     * 设置 [商品名称]
     */
    public void setSpmc(String spmc) {
        this.spmc = spmc;
        this.modify("spmc", spmc);
    }

    /**
     * 设置 [盘低]
     */
    public void setPd(BigDecimal pd) {
        this.pd = pd;
        this.modify("pd", pd);
    }

    /**
     * 设置 [统计]
     */
    public void setTj(String tj) {
        this.tj = tj;
        this.modify("tj", tj);
    }


    /**
     * 设置 [盘高]
     */
    public void setPg(BigDecimal pg) {
        this.pg = pg;
        this.modify("pg", pg);
    }

    /**
     * 设置 [开盘]
     */
    public void setKp(BigDecimal kp) {
        this.kp = kp;
        this.modify("kp", kp);
    }



    

    /**
     * 复制当前对象数据到目标对象(粘贴重置)
     * @param targetEntity 目标数据对象
     * @param bIncEmpty  是否包括空值
     * @param <T>
     * @return
     */
    @Override
    public <T> T copyTo(T targetEntity, boolean bIncEmpty) {
        this.reset("ibizsample0009id");        
        return super.copyTo(targetEntity, bIncEmpty);
    }    
}