package cn.ibizlab.core.sample.domain;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.math.BigInteger;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import org.springframework.util.ObjectUtils;
import org.springframework.util.DigestUtils;
import org.springframework.util.Assert;
import cn.ibizlab.util.domain.EntityBase;
import cn.ibizlab.util.annotation.DEField;
import cn.ibizlab.util.enums.DEPredefinedFieldType;
import cn.ibizlab.util.enums.DEFieldDefaultValueType;
import cn.ibizlab.util.helper.DataObject;
import cn.ibizlab.util.annotation.Audit;
import cn.ibizlab.util.enums.DupCheck;
import cn.ibizlab.util.domain.EntityMP;
import java.io.Serializable;
import lombok.*;
import lombok.experimental.Accessors;
import org.springframework.data.annotation.Transient;
import org.springframework.data.annotation.Id;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.baomidou.mybatisplus.annotation.*;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;

@Getter
@Setter
@NoArgsConstructor
@JsonIgnoreProperties(value = "handler")
@TableName(value = "T_IBIZSAMPLE0002", resultMap = "IBIZSample0002ResultMap")
@ApiModel(value = "IBIZSAMPLE0002", description = "示例实体02")
public class IBIZSample0002 extends EntityMP implements Serializable
{

    /**
     * 实体
     */
    @TableField(value = "de")
    @DEField(name = "de")
    @JsonProperty("de")
    @JSONField(name = "de")
    @ApiModelProperty(value = "de", notes = "实体")
    private String de;

    /**
     * 实体数据量
     */
    @TableField(value = "denum")
    @DEField(name = "denum")
    @JsonProperty("denum")
    @JSONField(name = "denum")
    @ApiModelProperty(value = "denum", notes = "实体数据量")
    private Integer deNum;

    /**
     * 更新时间
     */
    @TableField(value = "updatedate")
    @DEField(name = "updatedate" , preType = DEPredefinedFieldType.UPDATEDATE)
    @JsonProperty("updatedate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatedate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "updatedate", notes = "更新时间")
    private Timestamp updateDate;

    /**
     * 更新人
     */
    @TableField(value = "updateman")
    @DEField(name = "updateman" , preType = DEPredefinedFieldType.UPDATEMAN , dict = "SysOperator")
    @JsonProperty("updateman")
    @JSONField(name = "updateman")
    @ApiModelProperty(value = "updateman", notes = "更新人")
    private String updateMan;

    /**
     * 首页图表数据源名称
     */
    @TableField(value = "ibizsample0002name")
    @DEField(name = "ibizsample0002name")
    @JsonProperty("ibizsample0002name")
    @JSONField(name = "ibizsample0002name")
    @ApiModelProperty(value = "ibizsample0002name", notes = "首页图表数据源名称")
    private String ibizSample0002Name;

    /**
     * 建立人
     */
    @TableField(value = "createman" , fill = FieldFill.INSERT)
    @DEField(name = "createman" , preType = DEPredefinedFieldType.CREATEMAN , dict = "SysOperator")
    @JsonProperty("createman")
    @JSONField(name = "createman")
    @ApiModelProperty(value = "createman", notes = "建立人")
    private String createMan;

    /**
     * 首页图表数据源标识
     */
    @Id
    @TableId(value = "ibizsample0002id" , type = IdType.ASSIGN_UUID)
    @DEField(name = "ibizsample0002id" , isKeyField = true)
    @JsonProperty("ibizsample0002id")
    @JSONField(name = "ibizsample0002id")
    @ApiModelProperty(value = "ibizsample0002id", notes = "首页图表数据源标识")
    private String ibizSample0002Id;

    /**
     * 建立时间
     */
    @TableField(value = "createdate" , fill = FieldFill.INSERT)
    @DEField(name = "createdate" , preType = DEPredefinedFieldType.CREATEDATE)
    @JsonProperty("createdate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createdate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "createdate", notes = "建立时间")
    private Timestamp createDate;




    /**
     * 设置 [实体]
     */
    public void setDe(String de) {
        this.de = de;
        this.modify("de", de);
    }

    /**
     * 设置 [实体数据量]
     */
    public void setDeNum(Integer deNum) {
        this.deNum = deNum;
        this.modify("denum", deNum);
    }



    /**
     * 设置 [首页图表数据源名称]
     */
    public void setIbizSample0002Name(String ibizSample0002Name) {
        this.ibizSample0002Name = ibizSample0002Name;
        this.modify("ibizsample0002name", ibizSample0002Name);
    }






    

    /**
     * 复制当前对象数据到目标对象(粘贴重置)
     * @param targetEntity 目标数据对象
     * @param bIncEmpty  是否包括空值
     * @param <T>
     * @return
     */
    @Override
    public <T> T copyTo(T targetEntity, boolean bIncEmpty) {
        this.reset("ibizsample0002id");        
        return super.copyTo(targetEntity, bIncEmpty);
    }    
}