// 基于 @CONTROL/表格/MODEL.ts.ftl 生成
/**
 * Main 部件模型
 *
 * @export
 * @class MainModel
 */
export default class MainModel {

	/**
	 * 是否是实体数据导出
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public isDEExport: boolean = false;

	/**
	 * 获取数据项集合
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public getDataItems(): any[] {
    if(this.isDEExport){
		  return [
      ]
    }else{
		  return [
        {
          name: 'productuid',
          prop: 'productuid',
          dataType: 'TEXT',
        },
        {
          name: 'ibizhardwarename',
          prop: 'ibizhardwarename',
          dataType: 'TEXT',
        },
        {
          name: 'unit',
          prop: 'unit',
          dataType: 'TEXT',
        },
        {
          name: 'unitprice',
          prop: 'unitprice',
          dataType: 'FLOAT',
        },
        {
          name: 'producer',
          prop: 'producer',
          dataType: 'LONGTEXT_1000',
        },
        {
          name: 'ibizhardwareid',
          prop: 'ibizhardwareid',
          dataType: 'GUID',
        },
        {
          name: 'srfkey',
          prop: 'ibizhardwareid',
          dataType: 'GUID',
          isEditable:true
        },
        {
          name: 'srfdataaccaction',
          prop: 'ibizhardwareid',
          dataType: 'GUID',
        },
        {
          name: 'srfdatatype',
          prop: 'ibizhardwaretype',
          dataType: 'SSCODELIST',
        },
        {
          name: 'ibizhardwaretype',
          prop: 'ibizhardwaretype',
          dataType: 'SSCODELIST',
        },
        {
          name: 'srfmajortext',
          prop: 'ibizhardwarename',
          dataType: 'TEXT',
        },
        {
          name: 'ibizhardware',
          prop: 'ibizhardwareid',
        },

        {
          name:'size',
          prop:'size',
          dataType: 'QUERYPARAM'
        },
        {
          name:'query',
          prop:'query',
          dataType: 'QUERYPARAM'
        },
        {
          name:'filter',
          prop:'filter',
          dataType: 'QUERYPARAM'
        },
        {
          name:'page',
          prop:'page',
          dataType: 'QUERYPARAM'
        },
        {
          name:'sort',
          prop:'sort',
          dataType: 'QUERYPARAM'
        },
        {
          name:'srfparentdata',
          prop:'srfparentdata',
          dataType: 'QUERYPARAM'
        },
        // 前端新增修改标识，新增为"0",修改为"1"或未设值
        {
          name: 'srffrontuf',
          prop: 'srffrontuf',
          dataType: 'TEXT',
        },
        // 预置工作流数据字段
        {
          name: 'srfprocessdefinitionkey',
          prop: 'srfprocessdefinitionkey',
          dataType: 'TEXT'
        },
        {
          name: 'srftaskdefinitionkey',
          prop: 'srftaskdefinitionkey',
          dataType: 'TEXT'
        },
        {
          name: 'srftaskid',
          prop: 'srftaskid',
          dataType: 'TEXT'
        }
      ]
    }
  }

}