import CounterService from '../counter-service';
/**
 * 订单关系数据计数器计数器服务对象基类
 * 基于 APP/src/counter/%APP_COUNTER%/%APP_COUNTER%-counter-base.ts.ftl 生成
 * @export
 * @class DemoIBIZORDERCounterServiceBase
 */
export default class DemoIBIZORDERCounterServiceBase extends CounterService {

    /**
     * Creates an instance of  DemoIBIZORDERCounterServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  DemoIBIZORDERCounterServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
        this.initCounterData();
        this.timer = setInterval(() => {
            this.fetchCounterData(this.context,this.viewparams);
        }, 60000);
    }

    /**
     * 初始化当前计数器数据对象
     * 
     * @param {*} [opts={}]
     * @memberof  DemoIBIZORDERCounterServiceBase
     */
    public initCounterData(){
        this.fetchCounterData(this.context,this.viewparams);
    }

    /**
     * 查询数据
     * 
     * @param {*} [opts={}]
     * @memberof  DemoIBIZORDERCounterServiceBase
     */
    public async fetchCounterData(context:any,data:any){
    }

    /**
     * 刷新数据
     *
     * @memberof DemoIBIZORDERCounterServiceBase
     */
    public async refreshData(){
        if (this['fetchCounterData'] && this['fetchCounterData'] instanceof Function) {
            await this.fetchCounterData(this.context,this.viewparams);
        }
    }

}