import { UIActionContext } from "@/logic/ui-logic";
import { LogicReturnType } from "@/logic/const/logic-return-type";
import { UILogicParamType } from "@/logic/const/ui-logic-param-type";
import { Util, Verify } from "@/utils";
import { AppMessageBox } from "@/utils/app-message-box/app-message-box";
import { Subject } from "rxjs";
import { Environment } from "@/environments/environment";
/**
 * 自定义表格数据加载
 *
 * @export
 * @class GridViewLoadUILogicBase
 */
export default class GridViewLoadUILogicBase {

    /**
     * Creates an instance of  GridViewLoadBase.
     * 
     * @param {*} [opts={}]
     * @memberof GridViewLoadUILogicBase
     */
    constructor(opts: any = {}) { }

    /**
     * 逻辑参数
     *
     * @protected
     * @type {any[]}
     * @memberof GridViewLoadUILogicBase
     */
    protected logicParams: any[] = [
        {
            name: '传入变量',
            codeName: 'Default',
            default: true,
            entityParam: true,
        },
        {
            name: '当前视图参数',
            codeName: 'viewParam',
            viewNavDataParam: true,
        },
        {
            name: '当前搜索表单',
            codeName: 'searchForm',
            ctrlParam: true,
        },
        {
            name: '当前表格',
            codeName: 'grid',
            activeCtrlParam: true,
            ctrlParam: true,
        },
        {
            name: '当前视图对象',
            codeName: 'view',
            activeViewParam: true,
        },
    ];

    /**
     * 执行前
     *
     * @param {*} args
     * @param {*} [context={}]
     * @param {*} [params={}]
     * @param {*} [$event]
     * @param {*} [xData]
     * @param {*} [actioncontext]
     * @param {string} [srfParentDeName]
     * @return {*} 
     * @memberof GridViewLoadUILogicBase
     */
    public beforeExecute(args: any, context: any = {}, params: any = {},
        $event?: any, xData?: any, actioncontext?: any, srfParentDeName?: string) {
        return new UIActionContext(this.logicParams, args, context, params, $event, xData, actioncontext, srfParentDeName)
    }

    /**
     * 执行
     *
     * @param {any[]} args
     * @param {*} [context={}]
     * @param {*} [params={}]
     * @param {*} [$event]
     * @param {*} [xData]
     * @param {*} [actionContext]
     * @param {string} [srfParentDeName]
     * @memberof GridViewLoadUILogicBase
     */
    async execute(args: any[], context:any = {} ,params: any = {}, $event?: any, xData?: any, actioncontext?: any, srfParentDeName?: string) {
        try {
            const actionContext = this.beforeExecute(args, context, params, $event, xData, actioncontext, srfParentDeName);
            await this.execute_begin_node(actionContext);
            return actionContext.getResult();
        } catch (error: any) {
            throw new Error(`${error && error.message ? error.message : '发生未知错误！'}`);
        }
    }

    /**
     * 获取条件参数
     *
     * @param {UIActionContext} actionContext 界面逻辑上下文
     * @param {string} param 节点参数
     * @param {string} property 参数属性
     * @return {*} 
     * @memberof GridViewLoadUILogicBase
     */
    public getCondParam(actionContext: UIActionContext, param: string, property: string) {
        const resultParam = actionContext.getParam(param).getReal();
        //  当不存在参数属性时，返回直接值
        if (property === '') {
            return resultParam;
        }
        if (resultParam && resultParam.hasOwnProperty(property)) {
            return resultParam[property];
        }
        return null;
    }

    /**
     * 开始
     *
     * @param {UIActionContext} actionContext 界面逻辑上下文
     * @memberof GridViewLoadUILogicBase
     */
    protected async execute_begin_node(actionContext: UIActionContext) {
        actionContext.setResult(actionContext.defaultParam.getReal());
        console.log('已完成执行 开始 节点');
        await this.execute_bindparam1_node(actionContext);
    }
    
    /**
     * 结束
     *
     * @param {UIActionContext} actionContext 界面逻辑上下文
     * @memberof GridViewLoadUILogicBase
     */
    protected async execute_end1_node(actionContext: UIActionContext) {
        const strReturnType: string = 'NONEVALUE';
        if (Object.is(strReturnType, LogicReturnType.NONEVALUE) || Object.is(strReturnType, LogicReturnType.NULLVALUE)) {
            actionContext.setResult(null);
        } else if (Object.is(strReturnType, LogicReturnType.SRCVALUE)) {
            actionContext.setResult('');
        } else if (Object.is(strReturnType, LogicReturnType.BREAK)) {
            actionContext.setResult(LogicReturnType.BREAK);
        } else if (Object.is(strReturnType, LogicReturnType.LOGICPARAM) || Object.is(strReturnType, LogicReturnType.LOGICPARAMFIELD)) {
            const returnParam = actionContext.getParam('');
            if (Object.is(strReturnType, LogicReturnType.LOGICPARAM)) {
                actionContext.setResult(returnParam.getReal());
            } else {
                actionContext.setResult(returnParam.get(''));
            }
        } else {
            throw new Error(`无法识别的返回值类型${strReturnType}`);
        }
        console.log('已完成执行 结束 节点');
    }
    
    /**
     * 视图部件调用
     *
     * @param {UIActionContext} actionContext 界面逻辑上下文
     * @memberof GridViewLoadUILogicBase
     */
    protected async execute_viewctrlinvoke2_node(actionContext: UIActionContext) {
        const invokeCtrl = 'grid';
        const invokeMethod = 'load';
        const invokeParam = 'viewParam';
        if (!invokeCtrl || !invokeMethod) {
            throw new Error(`界面对象或者调用方法缺失`);
        }
        const invokeUICtrl = actionContext.getParam(invokeCtrl).getReal();
        if (invokeUICtrl[invokeMethod] && invokeUICtrl[invokeMethod] instanceof Function) {
            try {
                const result = await invokeUICtrl[invokeMethod]();
                if (invokeParam) {
                    actionContext.getParam(invokeParam).bind(result);
                }
                actionContext.bindLastReturnParam(result);
            } catch (error:any) {
                throw new Error(`${invokeCtrl}界面对象调用${invokeMethod}方法发生异常`);
            }
        } else {
            throw new Error(`${invokeCtrl}界面对象不存在${invokeMethod}方法`);
        }
        console.log('已完成执行 视图部件调用 节点');
        await this.execute_end1_node(actionContext);
    }
    
    /**
     * 视图部件调用
     *
     * @param {UIActionContext} actionContext 界面逻辑上下文
     * @memberof GridViewLoadUILogicBase
     */
    protected async execute_viewctrlinvoke1_node(actionContext: UIActionContext) {
        const invokeCtrl = 'searchForm';
        const invokeMethod = 'loadDraft';
        const invokeParam = 'viewParam';
        if (!invokeCtrl || !invokeMethod) {
            throw new Error(`界面对象或者调用方法缺失`);
        }
        const invokeUICtrl = actionContext.getParam(invokeCtrl).getReal();
        if (invokeUICtrl[invokeMethod] && invokeUICtrl[invokeMethod] instanceof Function) {
            try {
                const result = await invokeUICtrl[invokeMethod]();
                if (invokeParam) {
                    actionContext.getParam(invokeParam).bind(result);
                }
                actionContext.bindLastReturnParam(result);
            } catch (error:any) {
                throw new Error(`${invokeCtrl}界面对象调用${invokeMethod}方法发生异常`);
            }
        } else {
            throw new Error(`${invokeCtrl}界面对象不存在${invokeMethod}方法`);
        }
        console.log('已完成执行 视图部件调用 节点');
        await this.execute_viewctrlinvoke2_node(actionContext);
    }
    
    /**
     * 绑定当前搜索表单
     *
     * @param {UIActionContext} actionContext 界面逻辑上下文
     * @memberof GridViewLoadUILogicBase
     */
    protected async execute_bindparam1_node(actionContext: UIActionContext) {
        try {
            //  源数据
            const srcParam = actionContext.getParam('view');
            //  目标数据
            const dstParam = actionContext.getParam('searchForm');
            //  源属性
            const srcFieldName: string = 'searchform';
            if (srcFieldName) {
                dstParam.bind(srcParam.get(srcFieldName));
            } else {
                dstParam.bind(srcParam.getReal());
            }
            actionContext.bindLastReturnParam(null);
        } catch (error: any) {
            throw new Error(`逻辑参数当前搜索表单 ${error && error.message ? error.message : '发生未知错误!'}`);
        }
        console.log('已完成执行 绑定当前搜索表单 节点');
        await this.execute_viewctrlinvoke1_node(actionContext);
    }
    

}