import { UIActionContext } from "@/logic/ui-logic";
import { LogicReturnType } from "@/logic/const/logic-return-type";
import { UILogicParamType } from "@/logic/const/ui-logic-param-type";
import { Util, Verify } from "@/utils";
import { AppMessageBox } from "@/utils/app-message-box/app-message-box";
import { Subject } from "rxjs";
import { Environment } from "@/environments/environment";
/**
 * 自定义表格视图销毁
 *
 * @export
 * @class CustomViewDestroyUILogicBase
 */
export default class CustomViewDestroyUILogicBase {

    /**
     * Creates an instance of  customViewDestroyBase.
     * 
     * @param {*} [opts={}]
     * @memberof CustomViewDestroyUILogicBase
     */
    constructor(opts: any = {}) { }

    /**
     * 逻辑参数
     *
     * @protected
     * @type {any[]}
     * @memberof CustomViewDestroyUILogicBase
     */
    protected logicParams: any[] = [
        {
            name: '传入变量',
            codeName: 'Default',
            default: true,
            entityParam: true,
        },
    ];

    /**
     * 执行前
     *
     * @param {*} args
     * @param {*} [context={}]
     * @param {*} [params={}]
     * @param {*} [$event]
     * @param {*} [xData]
     * @param {*} [actioncontext]
     * @param {string} [srfParentDeName]
     * @return {*} 
     * @memberof CustomViewDestroyUILogicBase
     */
    public beforeExecute(args: any, context: any = {}, params: any = {},
        $event?: any, xData?: any, actioncontext?: any, srfParentDeName?: string) {
        return new UIActionContext(this.logicParams, args, context, params, $event, xData, actioncontext, srfParentDeName)
    }

    /**
     * 执行
     *
     * @param {any[]} args
     * @param {*} [context={}]
     * @param {*} [params={}]
     * @param {*} [$event]
     * @param {*} [xData]
     * @param {*} [actionContext]
     * @param {string} [srfParentDeName]
     * @memberof CustomViewDestroyUILogicBase
     */
    async execute(args: any[], context:any = {} ,params: any = {}, $event?: any, xData?: any, actioncontext?: any, srfParentDeName?: string) {
        try {
            const actionContext = this.beforeExecute(args, context, params, $event, xData, actioncontext, srfParentDeName);
            await this.execute_begin_node(actionContext);
            return actionContext.getResult();
        } catch (error: any) {
            throw new Error(`${error && error.message ? error.message : '发生未知错误！'}`);
        }
    }

    /**
     * 获取条件参数
     *
     * @param {UIActionContext} actionContext 界面逻辑上下文
     * @param {string} param 节点参数
     * @param {string} property 参数属性
     * @return {*} 
     * @memberof CustomViewDestroyUILogicBase
     */
    public getCondParam(actionContext: UIActionContext, param: string, property: string) {
        const resultParam = actionContext.getParam(param).getReal();
        //  当不存在参数属性时，返回直接值
        if (property === '') {
            return resultParam;
        }
        if (resultParam && resultParam.hasOwnProperty(property)) {
            return resultParam[property];
        }
        return null;
    }

    /**
     * 开始
     *
     * @param {UIActionContext} actionContext 界面逻辑上下文
     * @memberof CustomViewDestroyUILogicBase
     */
    protected async execute_begin_node(actionContext: UIActionContext) {
        actionContext.setResult(actionContext.defaultParam.getReal());
        console.log('已完成执行 开始 节点');
        await this.execute_end1_node(actionContext);
    }
    
    /**
     * 结束
     *
     * @param {UIActionContext} actionContext 界面逻辑上下文
     * @memberof CustomViewDestroyUILogicBase
     */
    protected async execute_end1_node(actionContext: UIActionContext) {
        const strReturnType: string = 'LOGICPARAM';
        if (Object.is(strReturnType, LogicReturnType.NONEVALUE) || Object.is(strReturnType, LogicReturnType.NULLVALUE)) {
            actionContext.setResult(null);
        } else if (Object.is(strReturnType, LogicReturnType.SRCVALUE)) {
            actionContext.setResult('');
        } else if (Object.is(strReturnType, LogicReturnType.BREAK)) {
            actionContext.setResult(LogicReturnType.BREAK);
        } else if (Object.is(strReturnType, LogicReturnType.LOGICPARAM) || Object.is(strReturnType, LogicReturnType.LOGICPARAMFIELD)) {
            const returnParam = actionContext.getParam('Default');
            if (Object.is(strReturnType, LogicReturnType.LOGICPARAM)) {
                actionContext.setResult(returnParam.getReal());
            } else {
                actionContext.setResult(returnParam.get(''));
            }
        } else {
            throw new Error(`无法识别的返回值类型${strReturnType}`);
        }
        console.log('已完成执行 结束 节点');
    }
    

}