import { MockAdapter } from '@/mock/mock-adapter';
const mock = MockAdapter.getInstance();

import Mock from 'mockjs'
const Random = Mock.Random;

// 获取应用数据
mock.onGet('v7/main-menuappmenu').reply((config: any) => {
    let status = MockAdapter.mockStatus(config);
    return [status, {
        name: 'appmenu',
        items:  [
            {
	id: 'D9ED4124-D1E7-419D-A3BA-A975E5144966',
	name: 'menuitem1',
	text: '工作台',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '工作台',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: true,
	iconcls: 'fa fa-jsfiddle',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc66',
	resourcetag: '',
},
            {
	id: '993EB242-5B31-4B91-A22C-32B4138770C4',
	name: 'menuitem3',
	text: '控件',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '控件',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: 'fa fa-cube',
	icon: '',
	textcls: '',
	appfunctag: '',
	resourcetag: '',
	items: [
		{
	id: '6D0F78A1-CF2A-4742-8550-E775F936B14B',
	name: 'menuitem6',
	text: '默认数据类型',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '默认数据类型',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto338',
	resourcetag: '',
},
		{
	id: '07CC7586-4A3F-4B29-A03A-F0C7F5473149',
	name: 'menuitem7',
	text: '默认编辑器类型',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '默认编辑器类型',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto222',
	resourcetag: '',
},
		{
	id: 'B82959D5-89FA-4B61-B7D5-7B45F4588B61',
	name: 'menuitem72',
	text: '扩展编辑器',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '扩展编辑器',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc',
	resourcetag: '',
},
		{
	id: 'A23AA3F2-C248-4106-9712-D3D5726FB1EB',
	name: 'menuitem65',
	text: '微服务组件',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '微服务组件',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc89',
	resourcetag: '',
},
		{
	id: 'FDCF3484-A4C9-4170-BC5A-35CA53C4B533',
	name: 'menuitem151',
	text: '编辑器插件示例',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '编辑器插件示例',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc70',
	resourcetag: '',
},
	],
},
            {
	id: '96AEAC0F-1046-49D4-B430-0B4D213CE876',
	name: 'menuitem4',
	text: '部件',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '部件',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: 'fa fa-cubes',
	icon: '',
	textcls: '',
	appfunctag: '',
	resourcetag: '',
	items: [
		{
	id: '355F58FA-9D3D-4A8D-86A9-96AA54F08AA0',
	name: 'menuitem112',
	text: '应用类',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '应用类',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: '',
	resourcetag: '',
	items: [
		{
	id: '2A433553-1CD9-424E-B743-4CAF821636BC',
	name: 'menuitem186',
	text: '数据看板',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '数据看板',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc50',
	resourcetag: '',
},
		{
	id: 'E22F7C00-F192-4EBE-9F49-9EDA7026DE49',
	name: 'menuitem129',
	text: '门户部件',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '门户部件',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc82',
	resourcetag: '',
},
	],
},
		{
	id: 'F97180DC-497C-4CF8-82BB-B402ABA47CEC',
	name: 'menuitem156',
	text: '表单类',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '表单类',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: '',
	resourcetag: '',
	items: [
		{
	id: 'C75444B9-857C-4369-8592-3EECF8A8EA6C',
	name: 'menuitem12',
	text: '编辑表单',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '编辑表单',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: '',
	resourcetag: '',
	items: [
		{
	id: '65044C5A-C883-4248-8C2F-87F2F9F1AD97',
	name: 'menuitem15',
	text: '基础表单项',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '基础表单项',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto393',
	resourcetag: '',
},
		{
	id: '2B046E9B-EECB-4916-A6E6-2B7AC13EA0CF',
	name: 'menuitem107',
	text: '内置功能',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '内置功能',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc31',
	resourcetag: '',
},
		{
	id: 'C72B5DDB-7D10-46EE-A7D3-845A71B2D46D',
	name: 'menuitem47',
	text: '新建默认值',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '新建默认值',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto319',
	resourcetag: '',
},
		{
	id: '474EE83E-71B7-42E9-9DCE-EAEDAB9F8C4B',
	name: 'menuitem99',
	text: '更新默认值',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '更新默认值',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc23',
	resourcetag: '',
},
		{
	id: '54FC50BA-5B71-4B32-848D-8934A57A27E9',
	name: 'menuitem48',
	text: '输入提示',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '输入提示',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto279',
	resourcetag: '',
},
		{
	id: '7DA2192A-DF0B-48D0-A1B4-55B3BA6B6340',
	name: 'menuitem49',
	text: '辅助输入',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '辅助输入',
	expanded: false,
	separator: false,
	hidden: true,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto129',
	resourcetag: '',
},
		{
	id: '45D8D3EA-29AE-493D-8F80-D643A9049DC7',
	name: 'menuitem50',
	text: '自动填充',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '自动填充',
	expanded: false,
	separator: false,
	hidden: true,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto371',
	resourcetag: '',
},
		{
	id: '37C1507C-566D-4AF2-A4BF-75D824D77A28',
	name: 'menuitem51',
	text: '超链接',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '超链接',
	expanded: false,
	separator: false,
	hidden: true,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto111',
	resourcetag: '',
},
		{
	id: '5FBBB62D-2F19-4C08-85B9-000831A14212',
	name: 'menuitem52',
	text: '表单值重置',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '表单值重置',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto106',
	resourcetag: '',
},
		{
	id: '3EA33D4E-8C0F-4D25-BFEC-2B0110AA3110',
	name: 'menuitem55',
	text: '动态显示',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '动态显示',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto155',
	resourcetag: '',
},
		{
	id: 'D2855975-9937-45AF-B8D6-A2E88DDD0C12',
	name: 'menuitem53',
	text: '动态启用',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '动态启用',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto151',
	resourcetag: '',
},
		{
	id: '2301F55C-6557-4E41-8FD9-96427703723F',
	name: 'menuitem54',
	text: '动态空输入',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '动态空输入',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto81',
	resourcetag: '',
},
		{
	id: '7FF1031A-9E04-40D7-A4F2-8ED79B7DA658',
	name: 'menuitem56',
	text: '表单项更新',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '表单项更新',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto114',
	resourcetag: '',
},
		{
	id: '2B2D5166-8778-438D-8C1E-740F9BFA3774',
	name: 'menuitem108',
	text: '表单值规则',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '表单值规则',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc32',
	resourcetag: '',
},
	],
},
		{
	id: 'ACAC251D-92FD-4592-B47D-28647CA82529',
	name: 'menuitem16',
	text: '搜索表单',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '搜索表单',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto173',
	resourcetag: '',
},
	],
},
		{
	id: '1BAC928C-E809-48D4-B43D-42A3A9351C61',
	name: 'menuitem157',
	text: '导航类',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '导航类',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: '',
	resourcetag: '',
	items: [
		{
	id: 'A5439F9B-D8FA-4B28-B7BC-2C9D4E0D5341',
	name: 'menuitem120',
	text: '分页导航',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '分页导航',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc42',
	resourcetag: '',
},
		{
	id: '5419AA53-A0D8-4927-8E50-440DB24D1FAC',
	name: 'menuitem128',
	text: '表格导航',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '表格导航',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc46',
	resourcetag: '',
},
		{
	id: '28DC72C0-3132-4698-8203-02B75F749934',
	name: 'menuitem114',
	text: '列表导航',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '列表导航',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc56',
	resourcetag: '',
},
		{
	id: '98FA5C20-9EF2-4F91-9EEB-1A679A12222B',
	name: 'menuitem137',
	text: '卡片导航',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '卡片导航',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc58',
	resourcetag: '',
},
		{
	id: 'C5CA0DBB-3CCD-42E3-A133-662D1C232C11',
	name: 'menuitem136',
	text: '树导航',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '树导航',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc57',
	resourcetag: '',
},
		{
	id: '43752D38-BF3B-45E5-A31F-0D1F17EEEF04',
	name: 'menuitem138',
	text: '日历导航',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '日历导航',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc59',
	resourcetag: '',
},
		{
	id: '8525A910-7ECC-4496-8AA8-11D3607F26FB',
	name: 'menuitem139',
	text: '时间轴导航',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '时间轴导航',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc60',
	resourcetag: '',
},
		{
	id: '07C59C67-FEC1-49A7-9330-F84F9AB4F0AF',
	name: 'menuitem20',
	text: '数据关系分页',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '数据关系分页',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: '',
	resourcetag: '',
	items: [
		{
	id: '93FFE50A-2ABB-49A4-89C8-BC09FC71C092',
	name: 'menuitem117',
	text: '数据关系分页（上下关系）',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '数据关系分页（上下关系）',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc41',
	resourcetag: '',
},
		{
	id: '8B3F6885-1F4A-4968-B1A0-3AEE107E79B4',
	name: 'menuitem118',
	text: '数据关系分页（分页关系）',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '数据关系分页（分页关系）',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto337',
	resourcetag: '',
},
	],
},
		{
	id: '37BB5AC5-EABE-4867-81B2-C34302DED238',
	name: 'menuitem116',
	text: ' 数据关系栏',
	type: 'MENUITEM',
	counterid: '',
	tooltip: ' 数据关系栏',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto402',
	resourcetag: '',
},
	],
},
		{
	id: 'B62C6578-C4E4-4B0E-AD64-9556DAEC7953',
	name: 'menuitem158',
	text: '面板类',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '面板类',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: '',
	resourcetag: '',
	items: [
		{
	id: 'CFD7096E-6EE8-4790-B888-A6CDB48E06B2',
	name: 'menuitem145',
	text: '选择视图面板',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '选择视图面板',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc64',
	resourcetag: '',
},
		{
	id: 'F083F5A4-9733-4159-9F66-630FD2CBE937',
	name: 'menuitem17',
	text: '向导面板',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '向导面板',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: '',
	resourcetag: '',
	items: [
		{
	id: '6510EAB0-C65D-4F34-9D1B-FB4B1CDD1862',
	name: 'menuitem134',
	text: '基础用法',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '基础用法',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc49',
	resourcetag: '',
},
		{
	id: '498947E5-86EF-434C-9381-D2CF6B69AD0A',
	name: 'menuitem135',
	text: '状态属性',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '状态属性',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc51',
	resourcetag: '',
},
	],
},
		{
	id: 'B2605A1B-A91F-480F-AC48-707FFA5DCA91',
	name: 'menuitem121',
	text: '多编辑视图面板',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '多编辑视图面板',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: '',
	resourcetag: '',
	items: [
		{
	id: '1EC6115F-FAC2-467F-B06F-4742A330D480',
	name: 'menuitem115',
	text: '多表单（行记录）',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '多表单（行记录）',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc36',
	resourcetag: '',
},
		{
	id: 'A7AE1C68-22AB-4CC3-9DBD-487ADD457A79',
	name: 'menuitem123',
	text: '多表单（上分页）',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '多表单（上分页）',
	expanded: false,
	separator: false,
	hidden: true,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc43',
	resourcetag: '',
},
	],
},
	],
},
		{
	id: 'C2AEB74A-9CA4-43C3-AEB6-A9A41B7B26AE',
	name: 'menuitem119',
	text: '多数据类',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '多数据类',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: '',
	resourcetag: '',
	items: [
		{
	id: '36ABAC78-40A9-4639-8E5B-670BFD6C80B9',
	name: 'menuitem13',
	text: '表格',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '表格',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: '',
	resourcetag: '',
	items: [
		{
	id: '8BC1B6FE-0C7F-43E5-A39B-B405A68D96B9',
	name: 'menuitem57',
	text: '禁用排序',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '禁用排序',
	expanded: false,
	separator: false,
	hidden: true,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto176',
	resourcetag: '',
},
		{
	id: '3B3BC8F3-16C2-4CC0-9F02-1DA4F6D96A81',
	name: 'menuitem59',
	text: '行操作',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '行操作',
	expanded: false,
	separator: false,
	hidden: true,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto286',
	resourcetag: '',
},
		{
	id: '7FD9D2A0-91CA-4368-9195-36AC9FDAFC20',
	name: 'menuitem58',
	text: '行编辑',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '行编辑',
	expanded: false,
	separator: false,
	hidden: true,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto124',
	resourcetag: '',
},
		{
	id: '178EA929-8BBD-4F66-8B65-BCB7BAE07B47',
	name: 'menuitem73',
	text: '内置功能',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '内置功能',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc2',
	resourcetag: '',
},
		{
	id: '2C8BD0B6-2D55-49B4-BF1A-4DE2C6082E35',
	name: 'menuitem74',
	text: '表格行编辑',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '表格行编辑',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc3',
	resourcetag: '',
},
		{
	id: '4E8C2C6A-D6C3-4DB6-848C-B36272359B87',
	name: 'menuitem75',
	text: '新建默认值',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '新建默认值',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc4',
	resourcetag: '',
},
		{
	id: '31BFCBE9-5C1B-4940-8939-A7E32B7504B4',
	name: 'menuitem76',
	text: '更新默认值',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '更新默认值',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc5',
	resourcetag: '',
},
		{
	id: '7D4387F7-3455-4816-A943-ACEB9654C981',
	name: 'menuitem77',
	text: '表格值规则',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '表格值规则',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc6',
	resourcetag: '',
},
		{
	id: '759F4AEE-EDF7-4716-A425-3F41DEFCD818',
	name: 'menuitem132',
	text: '表格列更新',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '表格列更新',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc54',
	resourcetag: '',
},
		{
	id: '5C6D9383-8FFB-472E-9601-57D228E425DD',
	name: 'menuitem133',
	text: '表格列重置',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '表格列重置',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc55',
	resourcetag: '',
},
		{
	id: 'A9B9BC3C-5676-4287-984D-CF916C110C9A',
	name: 'menuitem78',
	text: '自动分组',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '自动分组',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc7',
	resourcetag: '',
},
		{
	id: '57D9C9D1-120F-4628-AF03-4181EE921BCC',
	name: 'menuitem80',
	text: '代码表分组',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '代码表分组',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc8',
	resourcetag: '',
},
		{
	id: '30BD17EB-91ED-430F-8D12-59D5D9676B8D',
	name: 'menuitem81',
	text: '当前页聚合',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '当前页聚合',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc9',
	resourcetag: '',
},
		{
	id: '288D4E37-768C-44C4-A62B-72C96E872D1F',
	name: 'menuitem82',
	text: '远程聚合',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '远程聚合',
	expanded: false,
	separator: false,
	hidden: true,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc10',
	resourcetag: '',
},
	],
},
		{
	id: 'E17AEC0B-F569-4FDC-8BE8-1F92D23C7D20',
	name: 'menuitem83',
	text: '列表',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '列表',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: '',
	resourcetag: '',
	items: [
		{
	id: 'EB026E87-8229-46F2-B765-C3F89DCC58AB',
	name: 'menuitem84',
	text: '内置功能',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '内置功能',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc11',
	resourcetag: '',
},
		{
	id: 'C8043266-E3AA-425B-A3B2-FABBC0D6837A',
	name: 'menuitem85',
	text: '自动分组',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '自动分组',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc12',
	resourcetag: '',
},
		{
	id: 'B1A610F2-18FF-4765-B05A-219234402BD9',
	name: 'menuitem86',
	text: '代码表分组',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '代码表分组',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc13',
	resourcetag: '',
},
		{
	id: '1EA396EA-581F-4AB7-9EA5-5165F73D1A69',
	name: 'menuitem91',
	text: '项布局面板',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '项布局面板',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc17',
	resourcetag: '',
},
		{
	id: 'FF55CFFB-B9CC-43EF-9F61-F32070EC75EF',
	name: 'menuitem143',
	text: '自定义插件',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '自定义插件',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc65',
	resourcetag: '',
},
	],
},
		{
	id: '2F4CFE55-5E29-431F-A090-0C58867B4201',
	name: 'menuitem95',
	text: '日历',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '日历',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: '',
	resourcetag: '',
	items: [
		{
	id: 'B9064D3A-1F2A-4481-BEC3-59B023E273A7',
	name: 'menuitem96',
	text: '内置功能',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '内置功能',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc20',
	resourcetag: '',
},
		{
	id: '4BB67945-E582-4737-ABB1-83E4735B794B',
	name: 'menuitem97',
	text: '时间轴样式',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '时间轴样式',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc21',
	resourcetag: '',
},
		{
	id: '1379EA76-9160-4FD3-9807-DB51CB3B14F5',
	name: 'menuitem109',
	text: '项布局面板',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '项布局面板',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc29',
	resourcetag: '',
},
		{
	id: 'C51B8C4F-A9E2-4005-954F-B4CBC674C9DE',
	name: 'menuitem64',
	text: '自定义插件',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '自定义插件',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc72',
	resourcetag: '',
},
	],
},
		{
	id: 'B7F0403C-C40C-47C4-8AAB-348960B35C42',
	name: 'menuitem14',
	text: '树视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '树视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: '',
	resourcetag: '',
	items: [
		{
	id: 'D974FA09-314A-4736-A446-6828086ADEFA',
	name: 'menuitem60',
	text: '静态节点',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '静态节点',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto375',
	resourcetag: '',
},
		{
	id: 'FCA391E4-0E6F-4E7D-9422-3DBF10F101B9',
	name: 'menuitem61',
	text: '动态节点（代码表）',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '动态节点（代码表）',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto66',
	resourcetag: '',
},
		{
	id: '5C76924B-3C3B-4AF4-BD0D-0121B35D8411',
	name: 'menuitem62',
	text: '动态节点（实体）',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '动态节点（实体）',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto96',
	resourcetag: '',
},
		{
	id: '0DA74AB5-7221-4129-9B50-0F496070546C',
	name: 'menuitem63',
	text: '右键操作',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '右键操作',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto235',
	resourcetag: '',
},
	],
},
		{
	id: '0647E103-6FD7-48B1-B54B-97B0655B3500',
	name: 'menuitem111',
	text: '甘特图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '甘特图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc74',
	resourcetag: '',
},
		{
	id: 'D839814F-A805-4756-A1AE-A056BDC9B6B3',
	name: 'menuitem110',
	text: '树表格',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '树表格',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc73',
	resourcetag: '',
},
		{
	id: 'B842419A-2BB2-4CCA-9A20-DC2382551BBC',
	name: 'menuitem87',
	text: '数据视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '数据视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: '',
	resourcetag: '',
	items: [
		{
	id: '167B6A62-0B55-48AA-AF2E-73BBD597CCCF',
	name: 'menuitem88',
	text: '内置功能',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '内置功能',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc14',
	resourcetag: '',
},
		{
	id: '4F6352F1-6F88-4481-9361-1D707B03AE99',
	name: 'menuitem89',
	text: '自动分组',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '自动分组',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc15',
	resourcetag: '',
},
		{
	id: '00F6E3C2-C210-470A-ABBF-8ED48506CCF9',
	name: 'menuitem90',
	text: '代码表分组',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '代码表分组',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc16',
	resourcetag: '',
},
		{
	id: '3A8F7CCF-36F6-49E2-A02F-AFE092B98F3C',
	name: 'menuitem94',
	text: '项布局面板',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '项布局面板',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc19',
	resourcetag: '',
},
		{
	id: 'B9B3D9EC-812B-40E3-AB84-F67517F5082F',
	name: 'menuitem152',
	text: '自定义插件',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '自定义插件',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc71',
	resourcetag: '',
},
	],
},
		{
	id: 'DA9284C1-A9C0-4C61-8C05-5C7C200C4C16',
	name: 'menuitem101',
	text: '看板视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '看板视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: '',
	resourcetag: '',
	items: [
		{
	id: 'BC7062A6-46FF-4F24-BA8B-BF786787249D',
	name: 'menuitem102',
	text: '内置功能',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '内置功能',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc25',
	resourcetag: '',
},
		{
	id: '51E5EF98-18AE-464D-8786-ED236DC1CA42',
	name: 'menuitem104',
	text: '代码表分组',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '代码表分组',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc26',
	resourcetag: '',
},
		{
	id: '1390E8ED-0797-4D99-A0E9-3B88C3F0AD96',
	name: 'menuitem105',
	text: '项布局面板',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '项布局面板',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc27',
	resourcetag: '',
},
	],
},
		{
	id: '9E8A4ADC-482A-484E-A422-13BA37379A39',
	name: 'menuitem37',
	text: '数据图表',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '数据图表',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: '',
	resourcetag: '',
	items: [
		{
	id: '1F11772B-512A-40BC-A02E-3B12F88AFE61',
	name: 'menuitem38',
	text: '柱状图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '柱状图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto25',
	resourcetag: '',
},
		{
	id: '1DA2C72F-0670-4E8B-B8B1-BF863E4FBC85',
	name: 'menuitem39',
	text: '折线图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '折线图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto387',
	resourcetag: '',
},
		{
	id: '0D50699E-01FF-46C1-8A1E-E03FD4231891',
	name: 'menuitem40',
	text: '饼图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '饼图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto320',
	resourcetag: '',
},
		{
	id: '9711790B-CE73-47F5-8500-144A8F71C06C',
	name: 'menuitem41',
	text: '区域图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '区域图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto3',
	resourcetag: '',
},
		{
	id: '5B783A3C-1701-48F7-8207-39F378E7D9BD',
	name: 'menuitem42',
	text: '雷达图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '雷达图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto2',
	resourcetag: '',
},
	],
},
	],
},
	],
},
            {
	id: '6CE7C954-24C9-4667-BF95-02DBA05F3931',
	name: 'menuitem5',
	text: '视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: 'fa fa-file-photo-o',
	icon: '',
	textcls: '',
	appfunctag: '',
	resourcetag: '',
	items: [
		{
	id: 'B60B510C-A1A9-4A18-A9E9-8EE01CF41FDB',
	name: 'menuitem140',
	text: '单数据视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '单数据视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: '',
	resourcetag: '',
	items: [
		{
	id: '217B9C25-DE59-4C3F-8A7D-8EF6E29E5BAD',
	name: 'menuitem161',
	text: '实体向导视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '实体向导视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc49',
	resourcetag: '',
},
		{
	id: '6ACFC279-71A2-412B-AAFC-8DFED4EBFA27',
	name: 'menuitem8',
	text: '实体编辑视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '实体编辑视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc31',
	resourcetag: '',
},
		{
	id: 'B589A990-8D08-4225-B704-678D72FCEAD5',
	name: 'menuitem162',
	text: '实体编辑视图（分页关系）',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '实体编辑视图（分页关系）',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto337',
	resourcetag: '',
},
		{
	id: 'C3E1F1F0-2692-4439-BEA1-7E373C9F7B26',
	name: 'menuitem163',
	text: '实体编辑视图（上下关系）',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '实体编辑视图（上下关系）',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc41',
	resourcetag: '',
},
		{
	id: 'D80AE5E9-AF71-4495-8EAB-87B40080DE8C',
	name: 'menuitem164',
	text: '实体编辑视图（左右关系）',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '实体编辑视图（左右关系）',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto402',
	resourcetag: '',
},
		{
	id: '9803FA9D-9224-4E85-AFFD-C21BB7404A62',
	name: 'menuitem165',
	text: '实体分页导航视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '实体分页导航视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto213',
	resourcetag: '',
},
		{
	id: '1EB5597B-FC3F-455A-85B6-F96B464263CC',
	name: 'menuitem166',
	text: '实体数据看板视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '实体数据看板视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc45',
	resourcetag: '',
},
		{
	id: '204A2249-70C7-4244-8646-608B279BBEBB',
	name: 'menuitem167',
	text: '实体选项操作视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '实体选项操作视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc48',
	resourcetag: '',
},
	],
},
		{
	id: 'AC1D833A-1A12-4B4A-948E-FDAAA2D222F3',
	name: 'menuitem141',
	text: '多数据视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '多数据视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: '',
	resourcetag: '',
	items: [
		{
	id: '6142A62B-B434-4EAC-AF84-57B6C1243991',
	name: 'menuitem79',
	text: '实体表格视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '实体表格视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto299',
	resourcetag: '',
},
		{
	id: '8583F132-2318-4B6B-97FC-357C70FFEEC7',
	name: 'menuitem168',
	text: '实体多表单编辑视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '实体多表单编辑视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc43',
	resourcetag: '',
},
		{
	id: '52785274-CDDB-465E-A2C0-536304F341C1',
	name: 'menuitem169',
	text: '实体甘特视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '实体甘特视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc74',
	resourcetag: '',
},
		{
	id: 'B64C9FA6-7A0C-4C69-98C0-22810A88210F',
	name: 'menuitem9',
	text: '实体列表视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '实体列表视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc90',
	resourcetag: '',
},
		{
	id: '7A542E3F-A264-493A-9B3A-1060A711C6A5',
	name: 'menuitem170',
	text: '实体日历视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '实体日历视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc20',
	resourcetag: '',
},
		{
	id: '124EE13D-5E3E-40AC-A214-E647BB45B312',
	name: 'menuitem171',
	text: '实体看板视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '实体看板视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc25',
	resourcetag: '',
},
		{
	id: '385B2968-9E7F-4BF5-8837-AC9ED3D51A9C',
	name: 'menuitem172',
	text: '实体树表格视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '实体树表格视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc73',
	resourcetag: '',
},
		{
	id: '48F6D664-46FE-41BD-84F8-1FFED96B051B',
	name: 'menuitem173',
	text: '实体树视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '实体树视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc91',
	resourcetag: '',
},
		{
	id: '735048C0-C135-49D8-AA25-35D7CA23DE55',
	name: 'menuitem174',
	text: '实体数据视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '实体数据视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc14',
	resourcetag: '',
},
		{
	id: '519A647F-A2AF-467B-B2E8-5499020323CB',
	name: 'menuitem175',
	text: '实体图表视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '实体图表视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc35',
	resourcetag: '',
},
	],
},
		{
	id: '38FF8B2E-D41E-4FFF-9016-D86B41295912',
	name: 'menuitem10',
	text: '导航视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '导航视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: '',
	resourcetag: '',
	items: [
		{
	id: '4AF1BC86-0ECA-4101-9239-A409B3328423',
	name: 'menuitem176',
	text: '实体表格导航视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '实体表格导航视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc46',
	resourcetag: '',
},
		{
	id: '7CE8B92E-DB5A-4E51-B447-2641B21C95F4',
	name: 'menuitem177',
	text: '实体列表导航视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '实体列表导航视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc56',
	resourcetag: '',
},
		{
	id: '9DF43805-9BC5-4C5B-B609-29CC3F89F0DC',
	name: 'menuitem178',
	text: '实体卡片导航视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '实体卡片导航视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc58',
	resourcetag: '',
},
		{
	id: '4E48D024-631C-42C6-9186-55FE9DC71F34',
	name: 'menuitem179',
	text: '实体日历导航视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '实体日历导航视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc59',
	resourcetag: '',
},
		{
	id: 'B5A7FE2C-EC6F-4228-9C45-287E08E94E19',
	name: 'menuitem180',
	text: '实体树导航视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '实体树导航视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc57',
	resourcetag: '',
},
	],
},
		{
	id: '237A663F-4B14-4797-95B3-50B9AB634271',
	name: 'menuitem26',
	text: '选择视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '选择视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: '',
	resourcetag: '',
	items: [
		{
	id: '65C59409-2A54-4ED8-B9E1-8132F2A8180A',
	name: 'menuitem18',
	text: '数据选择视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '数据选择视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc64',
	resourcetag: '',
},
		{
	id: 'B2E0242E-ED21-443D-A7D5-ED36CE78B0F4',
	name: 'menuitem27',
	text: '索引选择视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '索引选择视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto296',
	resourcetag: '',
},
	],
},
		{
	id: 'DEB284EE-0C00-40AA-9E2E-74FDB728B49E',
	name: 'menuitem69',
	text: '工作流',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '工作流',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc85',
	resourcetag: '',
	items: [
		{
	id: 'DBA6ACEE-1536-4BB5-B383-F9CFCBDC448D',
	name: 'menuitem30',
	text: '工作流动态导航视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '工作流动态导航视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc85',
	resourcetag: '',
},
		{
	id: '74F3F16F-DEB5-46AA-AFCA-6C6B5D96E42D',
	name: 'menuitem31',
	text: '工作流启动',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '工作流启动',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc86',
	resourcetag: '',
},
		{
	id: '51AFEDFF-44FE-4ADC-9DE5-23DAF35EFC57',
	name: 'menuitem21',
	text: '工作流动态操作视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '工作流动态操作视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc94',
	resourcetag: '',
},
	],
},
		{
	id: '12C15578-7086-41A9-B87D-FAF31E467E4F',
	name: 'menuitem11',
	text: '其他视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '其他视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: '',
	resourcetag: '',
	items: [
		{
	id: '1C50F814-4687-45D3-896A-0A1B61D11987',
	name: 'menuitem98',
	text: '自定义视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '自定义视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc22',
	resourcetag: '',
},
	],
},
	],
},
            {
	id: 'E9C8E90B-364D-4247-B3AF-7158E1E91B12',
	name: 'menuitem153',
	text: '逻辑',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '逻辑',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: 'fa fa-skyatlas',
	icon: '',
	textcls: '',
	appfunctag: '',
	resourcetag: '',
	items: [
		{
	id: 'CF313F1A-F466-4C01-B00D-A9057BD93D10',
	name: 'menuitem154',
	text: '应用功能',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '应用功能',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: '',
	resourcetag: '',
	items: [
		{
	id: '745DE533-B1B1-46FA-A035-99EAFDD2DF85',
	name: 'menuitem127',
	text: '打开应用视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '打开应用视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc2',
	resourcetag: '',
},
		{
	id: 'C91CE556-8861-4236-84DF-53815562400F',
	name: 'menuitem147',
	text: '打开HTML页面',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '打开HTML页面',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc75',
	resourcetag: '',
},
		{
	id: '41351F80-3400-4CB6-85FD-9774BA133138',
	name: 'menuitem160',
	text: '执行JavaScript',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '执行JavaScript',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc78',
	resourcetag: '',
},
	],
},
		{
	id: '0A02BDFA-6234-453A-9CFB-45D980334F96',
	name: 'menuitem155',
	text: '界面行为',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '界面行为',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: '',
	resourcetag: '',
	items: [
		{
	id: 'E179B5F9-CFF4-40A0-8BAF-407A91C4D0E7',
	name: 'menuitem181',
	text: '前台界面行为',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '前台界面行为',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto67',
	resourcetag: '',
},
		{
	id: 'E6FE3168-4A51-4727-93E5-A21065077579',
	name: 'menuitem182',
	text: '后台界面行为',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '后台界面行为',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto39',
	resourcetag: '',
},
	],
},
	],
},
            {
	id: '7B75F84B-AD51-4339-A4E1-C8E7FBD5A46F',
	name: 'menuitem2',
	text: '更多',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '更多',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: 'fa fa-yelp',
	icon: '',
	textcls: '',
	appfunctag: '',
	resourcetag: '',
	items: [
		{
	id: '4E85F6A2-2467-4320-B831-866F27B00686',
	name: 'menuitem19',
	text: '临时模式',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '临时模式',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc95',
	resourcetag: '',
},
		{
	id: '2AE12804-05A2-4848-BAA8-724D1DB2CE34',
	name: 'menuitem46',
	text: '数据导出导入',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '数据导出导入',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc88',
	resourcetag: '',
},
		{
	id: 'B16ACB99-87F5-46CA-88A0-FEE426A31923',
	name: 'menuitem67',
	text: '索引实体',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '索引实体',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto296',
	resourcetag: '',
},
		{
	id: 'F630C504-E5AA-41D7-AA30-0CC5DFAFFBDC',
	name: 'menuitem184',
	text: '主状态',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '主状态',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: '',
	resourcetag: '',
	items: [
		{
	id: '96AC8A9A-7FF9-4C49-8610-EB948CA35253',
	name: 'menuitem70',
	text: '表格主状态',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '表格主状态',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc79',
	resourcetag: '',
},
		{
	id: 'EBB4BC71-4436-47EE-8EE5-90ABAED1E8EC',
	name: 'menuitem148',
	text: '列表主状态',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '列表主状态',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc80',
	resourcetag: '',
},
		{
	id: '279BE957-7FC4-42FC-B25B-A8C8D9453737',
	name: 'menuitem183',
	text: '数据主状态',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '数据主状态',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc81',
	resourcetag: '',
},
		{
	id: 'F2606F5B-CF28-4AF3-81AD-93539744823A',
	name: 'menuitem28',
	text: '日历主状态',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '日历主状态',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc83',
	resourcetag: '',
},
		{
	id: 'A8EEAB9D-85F8-4FB6-85F0-14A8ADB02567',
	name: 'menuitem29',
	text: '树主状态',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '树主状态',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc84',
	resourcetag: '',
},
	],
},
	],
},
            {
	id: 'C4E576F3-FBD2-459C-8D48-52D5F2EAB039',
	name: 'menuitem22',
	text: '测试',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '测试',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: '',
	resourcetag: '',
	items: [
		{
	id: 'D2872250-31D3-4C64-A196-8616E1D1125C',
	name: 'menuitem23',
	text: '卡片导航',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '卡片导航',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc96',
	resourcetag: '',
},
		{
	id: '666BAE66-76EA-4574-81FC-9FD788E1FB23',
	name: 'menuitem24',
	text: '表单嵌入卡片视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '表单嵌入卡片视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc97',
	resourcetag: '',
},
		{
	id: 'DFBC5669-2ED2-427D-8D47-EFD1F3E0BF47',
	name: 'menuitem25',
	text: '关系界面刷新主表单',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '关系界面刷新主表单',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc98',
	resourcetag: '',
},
	],
},
            {
	id: 'E175D786-50C7-41A2-94CE-FA7B4E53BDEF',
	name: 'menuitem66',
	text: '视图布局面板测试',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '视图布局面板测试',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: '',
	resourcetag: '',
	items: [
		{
	id: '4ECC40C2-A671-42DE-A711-D51C9C210A2B',
	name: 'menuitem125',
	text: '测试表单自定义布局多媒体',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '测试表单自定义布局多媒体',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc100',
	resourcetag: '',
},
		{
	id: '89230158-6C32-452E-91B3-395910F7474D',
	name: 'menuitem126',
	text: '自定义导航',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '自定义导航',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'UsrAppFunc1102681676',
	resourcetag: '',
},
		{
	id: '14553AF5-C156-4763-914C-95C67C9CF1C7',
	name: 'menuitem130',
	text: '布局面板组件测试',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '布局面板组件测试',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc101',
	resourcetag: '',
},
		{
	id: '9CFA4E22-F554-471E-B679-4F046DD6F1F6',
	name: 'menuitem205',
	text: '项布局面板测试',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '项布局面板测试',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc125',
	resourcetag: '',
},
		{
	id: 'C484800D-366A-4E51-8EB7-3C8C880084FD',
	name: 'menuitem131',
	text: '编辑视图（左右关系）',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '编辑视图（左右关系）',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'UsrAppFunc1103768001',
	resourcetag: '',
},
		{
	id: '73593064-1AE3-4F5D-B762-BDE3631D6E92',
	name: 'menuitem142',
	text: '列表视图（自定义面板）',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '列表视图（自定义面板）',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'UsrAppFunc1103202475',
	resourcetag: '',
},
		{
	id: '8939891C-C509-415C-B76E-07C2135E613B',
	name: 'menuitem189',
	text: '测试布局面板（树导航）',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '测试布局面板（树导航）',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'UsrAppFunc1104869965',
	resourcetag: '',
},
		{
	id: '315439DB-BB36-4094-A61E-CE3831725BB4',
	name: 'menuitem190',
	text: '视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: '',
	resourcetag: '',
	items: [
		{
	id: '85C37D27-D810-462C-81FE-BDE43E23EC8D',
	name: 'menuitem191',
	text: '单数据视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '单数据视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: '',
	resourcetag: '',
	items: [
		{
	id: '64BEFC7F-C291-49C1-A236-5364BA9D13FA',
	name: 'menuitem192',
	text: '实体向导视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '实体向导视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc102',
	resourcetag: '',
},
		{
	id: 'F922CCF0-180D-46C0-A67B-9D5E288DEE62',
	name: 'menuitem193',
	text: '实体编辑视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '实体编辑视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc103',
	resourcetag: '',
},
		{
	id: 'EC85806E-2370-437D-A0B3-C06EC98F7207',
	name: 'menuitem194',
	text: '实体编辑视图（分页关系）',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '实体编辑视图（分页关系）',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc104',
	resourcetag: '',
},
		{
	id: '1F572FB9-844D-457B-92AA-19DF58AEFCE1',
	name: 'menuitem195',
	text: '实体编辑视图（上下关系）',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '实体编辑视图（上下关系）',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc105',
	resourcetag: '',
},
		{
	id: '9E07FAD5-EA30-47B2-9A10-533BDC112244',
	name: 'menuitem196',
	text: '实体编辑视图（左右关系）',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '实体编辑视图（左右关系）',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc106',
	resourcetag: '',
},
		{
	id: '0BC177F1-041B-45CD-B38C-9E1ED1273600',
	name: 'menuitem197',
	text: '实体分页导航视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '实体分页导航视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc107',
	resourcetag: '',
},
		{
	id: '457F2AF3-0440-4397-B31C-0CFE6C950CAB',
	name: 'menuitem198',
	text: '实体数据看板视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '实体数据看板视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc108',
	resourcetag: '',
},
		{
	id: '4F892F70-882D-4010-AFE5-88763D2B3B89',
	name: 'menuitem199',
	text: '实体选项操作视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '实体选项操作视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc109',
	resourcetag: '',
},
	],
},
		{
	id: '26167393-6024-4333-85BC-190AE97B56A9',
	name: 'menuitem200',
	text: '多数据视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '多数据视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: '',
	resourcetag: '',
	items: [
		{
	id: 'DB35DE83-0109-4322-A185-0026B4A4D48D',
	name: 'menuitem122',
	text: '表格视图面板',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '表格视图面板',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc99',
	resourcetag: '',
},
		{
	id: 'F8FB1EA1-3B81-4A45-B3F7-648ABEF7361C',
	name: 'menuitem202',
	text: '实体多表单编辑视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '实体多表单编辑视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc110',
	resourcetag: '',
},
		{
	id: '3CD63AAA-A874-4B5C-AA16-30466B0C41E7',
	name: 'menuitem203',
	text: '实体甘特视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '实体甘特视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc111',
	resourcetag: '',
},
		{
	id: 'CDB9B2A4-4CC2-4F0E-AE82-E652E3B87FD6',
	name: 'menuitem204',
	text: '实体列表视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '实体列表视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc112',
	resourcetag: '',
},
		{
	id: '9118E2F4-6021-4D2B-A313-712FF060C265',
	name: 'menuitem187',
	text: '测试布局面板（日历视图）',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '测试布局面板（日历视图）',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'UsrAppFunc1103578816',
	resourcetag: '',
},
		{
	id: '9DF77D6A-0F57-4353-8DB0-13F90BC787D2',
	name: 'menuitem206',
	text: '实体看板视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '实体看板视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc113',
	resourcetag: '',
},
		{
	id: '45F83512-EF05-4EFD-9D7C-32D35B25D976',
	name: 'menuitem207',
	text: '实体树表格视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '实体树表格视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc114',
	resourcetag: '',
},
		{
	id: '439C87B1-A069-4E98-B986-E15879A47F29',
	name: 'menuitem185',
	text: '测试布局面板（树视图）',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '测试布局面板（树视图）',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'UsrAppFunc1103276204',
	resourcetag: '',
},
		{
	id: '9DAA57D2-0D6B-4FD3-8B50-0A53FBCD4BAC',
	name: 'menuitem159',
	text: '卡片视图（布局面板）',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '卡片视图（布局面板）',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'UsrAppFunc1103793182',
	resourcetag: '',
},
		{
	id: 'FFF49CBD-CAEB-440F-96E8-467D02C5445D',
	name: 'menuitem188',
	text: '测试布局面板（图表）',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '测试布局面板（图表）',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'UsrAppFunc1104195725',
	resourcetag: '',
},
	],
},
		{
	id: '8E373BE6-A54F-489D-8840-3A0C28638BA3',
	name: 'menuitem211',
	text: '导航视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '导航视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: '',
	resourcetag: '',
	items: [
		{
	id: '53405068-02C4-4C83-8E6D-BA0B8F0907A1',
	name: 'menuitem215',
	text: '实体表格导航视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '实体表格导航视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'UsrAppFunc1102681676',
	resourcetag: '',
},
		{
	id: 'D4694DF5-4F05-4BCF-8055-934863B183F9',
	name: 'menuitem216',
	text: '实体列表导航视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '实体列表导航视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc115',
	resourcetag: '',
},
		{
	id: 'AB602B8F-560B-4ADD-8585-090F552931BD',
	name: 'menuitem217',
	text: '实体卡片导航视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '实体卡片导航视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc116',
	resourcetag: '',
},
		{
	id: '5D2158F6-3BE8-41F1-A62E-D49CB0A89583',
	name: 'menuitem218',
	text: '实体日历导航视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '实体日历导航视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc117',
	resourcetag: '',
},
		{
	id: '78EA3065-DE2E-4315-AFAE-8289BC6EB27B',
	name: 'menuitem219',
	text: '实体树导航视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '实体树导航视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc118',
	resourcetag: '',
},
	],
},
		{
	id: '3AB505BE-FCCC-4B22-A1D3-45FCF473FED4',
	name: 'menuitem220',
	text: '选择视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '选择视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: '',
	resourcetag: '',
	items: [
		{
	id: '5477F814-811E-4716-A46F-B4BA496AF279',
	name: 'menuitem221',
	text: '数据选择视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '数据选择视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc119',
	resourcetag: '',
},
		{
	id: '32A12DA2-AEE6-4067-AFA9-044A8526321A',
	name: 'menuitem222',
	text: '索引选择视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '索引选择视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc120',
	resourcetag: '',
},
	],
},
		{
	id: 'FEAFDCA2-4331-4A7D-9AE0-BCACDAA9A898',
	name: 'menuitem223',
	text: '工作流',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '工作流',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc85',
	resourcetag: '',
	items: [
		{
	id: '5FAD0EA7-F9EC-4FB8-81F9-D6DF353EE307',
	name: 'menuitem224',
	text: '工作流动态导航视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '工作流动态导航视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc121',
	resourcetag: '',
},
		{
	id: 'E4D5431B-9325-4878-9EB5-CD214A93FFAF',
	name: 'menuitem225',
	text: '工作流启动',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '工作流启动',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc123',
	resourcetag: '',
},
		{
	id: '486FB200-558C-4387-8D16-287B47AB1600',
	name: 'menuitem226',
	text: '工作流动态操作视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '工作流动态操作视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc122',
	resourcetag: '',
},
	],
},
		{
	id: '930EA152-2130-4388-8233-9A3E33535EF8',
	name: 'menuitem227',
	text: '其他视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '其他视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: '',
	resourcetag: '',
	items: [
		{
	id: '055E4BE3-1CBC-408B-A1B2-A54AABC52E16',
	name: 'menuitem230',
	text: '自定义视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '自定义视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc124',
	resourcetag: '',
},
	],
},
	],
},
		{
	id: 'F0C9163C-0840-45AE-9D8C-0022448B282C',
	name: 'menuitem201',
	text: '测试界面逻辑',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '测试界面逻辑',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'UsrAppFunc1108357066',
	resourcetag: '',
},
	],
},
        ],
    }];
});

