package cn.ibizlab.demoapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.Data;

/**
 * 服务DTO对象[IBIZTASKDTO]
 */
@Data
public class IBIZTASKDTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [IBIZTASKID]
     *
     */
    @JSONField(name = "ibiztaskid")
    @JsonProperty("ibiztaskid")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String ibiztaskid;

    /**
     * 属性 [UPDATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "updatedate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;

    /**
     * 属性 [IBIZTASKNAME]
     *
     */
    @JSONField(name = "ibiztaskname")
    @JsonProperty("ibiztaskname")
    @Size(min = 0, max = 200, message = "内容长度必须小于等于[200]")
    private String ibiztaskname;

    /**
     * 属性 [CREATEMAN]
     *
     */
    @JSONField(name = "createman")
    @JsonProperty("createman")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    private String createman;

    /**
     * 属性 [UPDATEMAN]
     *
     */
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    private String updateman;

    /**
     * 属性 [CREATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "createdate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;

    /**
     * 属性 [TASKTEAM]
     *
     */
    @JSONField(name = "taskteam")
    @JsonProperty("taskteam")
    @Size(min = 0, max = 1048576, message = "内容长度必须小于等于[1048576]")
    private String taskteam;


    /**
     * 设置 [IBIZTASKNAME]
     */
    public void setIbiztaskname(String  ibiztaskname){
        this.ibiztaskname = ibiztaskname ;
        this.modify("ibiztaskname",ibiztaskname);
    }

    /**
     * 设置 [TASKTEAM]
     */
    public void setTaskteam(String  taskteam){
        this.taskteam = taskteam ;
        this.modify("taskteam",taskteam);
    }


    /**
     *  [IBIZTASKTEAM]
     */
    @JsonProperty("ibiztaskteams")
    @JSONField(name = "ibiztaskteams")
	private List<IBIZTASKTEAMDTO> ibiztaskteam ;

}


