package cn.ibizlab.demoapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.Data;

/**
 * 服务DTO对象[IBIZSample0002DTO]
 */
@Data
public class IBIZSample0002DTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [DE]
     *
     */
    @JSONField(name = "de")
    @JsonProperty("de")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String de;

    /**
     * 属性 [DENUM]
     *
     */
    @JSONField(name = "denum")
    @JsonProperty("denum")
    private Integer denum;

    /**
     * 属性 [UPDATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "updatedate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;

    /**
     * 属性 [UPDATEMAN]
     *
     */
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    private String updateman;

    /**
     * 属性 [IBIZSAMPLE0002NAME]
     *
     */
    @JSONField(name = "ibizsample0002name")
    @JsonProperty("ibizsample0002name")
    @Size(min = 0, max = 200, message = "内容长度必须小于等于[200]")
    private String ibizsample0002name;

    /**
     * 属性 [CREATEMAN]
     *
     */
    @JSONField(name = "createman")
    @JsonProperty("createman")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    private String createman;

    /**
     * 属性 [IBIZSAMPLE0002ID]
     *
     */
    @JSONField(name = "ibizsample0002id")
    @JsonProperty("ibizsample0002id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String ibizsample0002id;

    /**
     * 属性 [CREATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "createdate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;


    /**
     * 设置 [DE]
     */
    public void setDe(String  de){
        this.de = de ;
        this.modify("de",de);
    }

    /**
     * 设置 [DENUM]
     */
    public void setDenum(Integer  denum){
        this.denum = denum ;
        this.modify("denum",denum);
    }

    /**
     * 设置 [IBIZSAMPLE0002NAME]
     */
    public void setIbizsample0002name(String  ibizsample0002name){
        this.ibizsample0002name = ibizsample0002name ;
        this.modify("ibizsample0002name",ibizsample0002name);
    }


}


