package cn.ibizlab.demoapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.demoapi.dto.*;
import cn.ibizlab.demoapi.mapping.*;
import cn.ibizlab.core.sample.domain.IBIZAPPCTRL;
import cn.ibizlab.core.sample.service.IIBIZAPPCTRLService;
import cn.ibizlab.core.sample.filter.IBIZAPPCTRLSearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"应用部件" })
@RestController("DemoAPI-ibizappctrl")
@RequestMapping("")
public class IBIZAPPCTRLResource {

    @Autowired
    public IIBIZAPPCTRLService ibizappctrlService;

    @Autowired
    @Lazy
    public IBIZAPPCTRLMapping ibizappctrlMapping;

    @PreAuthorize("hasPermission(this.ibizappctrlMapping.toDomain(#ibizappctrldto),'DemoSys-IBIZAPPCTRL-Create')")
    @ApiOperation(value = "新建应用部件", tags = {"应用部件" },  notes = "新建应用部件")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizappctrls")
    public ResponseEntity<IBIZAPPCTRLDTO> create(@Validated @RequestBody IBIZAPPCTRLDTO ibizappctrldto) {
        IBIZAPPCTRL domain = ibizappctrlMapping.toDomain(ibizappctrldto);
		ibizappctrlService.create(domain);
        IBIZAPPCTRLDTO dto = ibizappctrlMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizappctrlMapping.toDomain(#ibizappctrldtos),'DemoSys-IBIZAPPCTRL-Create')")
    @ApiOperation(value = "批量新建应用部件", tags = {"应用部件" },  notes = "批量新建应用部件")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizappctrls/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<IBIZAPPCTRLDTO> ibizappctrldtos) {
        ibizappctrlService.createBatch(ibizappctrlMapping.toDomain(ibizappctrldtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @VersionCheck(entity = "ibizappctrl" , versionfield = "updatedate")
    @PreAuthorize("hasPermission(this.ibizappctrlService.get(#ibizappctrl_id),'DemoSys-IBIZAPPCTRL-Update')")
    @ApiOperation(value = "更新应用部件", tags = {"应用部件" },  notes = "更新应用部件")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibizappctrls/{ibizappctrl_id}")
    public ResponseEntity<IBIZAPPCTRLDTO> update(@PathVariable("ibizappctrl_id") String ibizappctrl_id, @RequestBody IBIZAPPCTRLDTO ibizappctrldto) {
		IBIZAPPCTRL domain  = ibizappctrlMapping.toDomain(ibizappctrldto);
        domain .setIbizappctrlid(ibizappctrl_id);
		ibizappctrlService.update(domain );
		IBIZAPPCTRLDTO dto = ibizappctrlMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizappctrlService.getIbizappctrlByEntities(this.ibizappctrlMapping.toDomain(#ibizappctrldtos)),'DemoSys-IBIZAPPCTRL-Update')")
    @ApiOperation(value = "批量更新应用部件", tags = {"应用部件" },  notes = "批量更新应用部件")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibizappctrls/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<IBIZAPPCTRLDTO> ibizappctrldtos) {
        ibizappctrlService.updateBatch(ibizappctrlMapping.toDomain(ibizappctrldtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(this.ibizappctrlService.get(#ibizappctrl_id),'DemoSys-IBIZAPPCTRL-Remove')")
    @ApiOperation(value = "删除应用部件", tags = {"应用部件" },  notes = "删除应用部件")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibizappctrls/{ibizappctrl_id}")
    public ResponseEntity<Boolean> remove(@PathVariable("ibizappctrl_id") String ibizappctrl_id) {
         return ResponseEntity.status(HttpStatus.OK).body(ibizappctrlService.remove(ibizappctrl_id));
    }

    @PreAuthorize("hasPermission(this.ibizappctrlService.getIbizappctrlByIds(#ids),'DemoSys-IBIZAPPCTRL-Remove')")
    @ApiOperation(value = "批量删除应用部件", tags = {"应用部件" },  notes = "批量删除应用部件")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibizappctrls/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        ibizappctrlService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PostAuthorize("hasPermission(this.ibizappctrlMapping.toDomain(returnObject.body),'DemoSys-IBIZAPPCTRL-Get')")
    @ApiOperation(value = "获取应用部件", tags = {"应用部件" },  notes = "获取应用部件")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizappctrls/{ibizappctrl_id}")
    public ResponseEntity<IBIZAPPCTRLDTO> get(@PathVariable("ibizappctrl_id") String ibizappctrl_id) {
        IBIZAPPCTRL domain = ibizappctrlService.get(ibizappctrl_id);
        IBIZAPPCTRLDTO dto = ibizappctrlMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "获取应用部件草稿", tags = {"应用部件" },  notes = "获取应用部件草稿")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizappctrls/getdraft")
    public ResponseEntity<IBIZAPPCTRLDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(ibizappctrlMapping.toDto(ibizappctrlService.getDraft(new IBIZAPPCTRL())));
    }

    @ApiOperation(value = "检查应用部件", tags = {"应用部件" },  notes = "检查应用部件")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizappctrls/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody IBIZAPPCTRLDTO ibizappctrldto) {
        return  ResponseEntity.status(HttpStatus.OK).body(ibizappctrlService.checkKey(ibizappctrlMapping.toDomain(ibizappctrldto)));
    }

    @PreAuthorize("hasPermission(this.ibizappctrlMapping.toDomain(#ibizappctrldto),'DemoSys-IBIZAPPCTRL-Save')")
    @ApiOperation(value = "保存应用部件", tags = {"应用部件" },  notes = "保存应用部件")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizappctrls/save")
    public ResponseEntity<Boolean> save(@RequestBody IBIZAPPCTRLDTO ibizappctrldto) {
        return ResponseEntity.status(HttpStatus.OK).body(ibizappctrlService.save(ibizappctrlMapping.toDomain(ibizappctrldto)));
    }

    @PreAuthorize("hasPermission(this.ibizappctrlMapping.toDomain(#ibizappctrldtos),'DemoSys-IBIZAPPCTRL-Save')")
    @ApiOperation(value = "批量保存应用部件", tags = {"应用部件" },  notes = "批量保存应用部件")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizappctrls/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<IBIZAPPCTRLDTO> ibizappctrldtos) {
        ibizappctrlService.saveBatch(ibizappctrlMapping.toDomain(ibizappctrldtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZAPPCTRL-searchDefault-all') and hasPermission(#context,'DemoSys-IBIZAPPCTRL-Get')")
	@ApiOperation(value = "获取数据集", tags = {"应用部件" } ,notes = "获取数据集")
    @RequestMapping(method= RequestMethod.GET , value="/ibizappctrls/fetchdefault")
	public ResponseEntity<List<IBIZAPPCTRLDTO>> fetchDefault(IBIZAPPCTRLSearchContext context) {
        Page<IBIZAPPCTRL> domains = ibizappctrlService.searchDefault(context) ;
        List<IBIZAPPCTRLDTO> list = ibizappctrlMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZAPPCTRL-searchDefault-all') and hasPermission(#context,'DemoSys-IBIZAPPCTRL-Get')")
	@ApiOperation(value = "查询数据集", tags = {"应用部件" } ,notes = "查询数据集")
    @RequestMapping(method= RequestMethod.POST , value="/ibizappctrls/searchdefault")
	public ResponseEntity<Page<IBIZAPPCTRLDTO>> searchDefault(@RequestBody IBIZAPPCTRLSearchContext context) {
        Page<IBIZAPPCTRL> domains = ibizappctrlService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(ibizappctrlMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


}

