import CounterService from '../counter-service';
/**
 * 流程导航栏计数器计数器服务对象基类
 * 基于 APP/src/counter/%APP_COUNTER%/%APP_COUNTER%-counter-base.ts.ftl 生成
 * @export
 * @class WFExpBarCounterServiceBase
 */
export default class WFExpBarCounterServiceBase extends CounterService {

    /**
     * Creates an instance of  WFExpBarCounterServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  WFExpBarCounterServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
        this.initCounterData();
        this.timer = setInterval(() => {
            this.fetchCounterData(this.context,this.viewparams);
        }, 60000);
    }

    /**
     * 初始化当前计数器数据对象
     * 
     * @param {*} [opts={}]
     * @memberof  WFExpBarCounterServiceBase
     */
    public initCounterData(){
        this.fetchCounterData(this.context,this.viewparams);
    }

    /**
     * 查询数据
     * 
     * @param {*} [opts={}]
     * @memberof  WFExpBarCounterServiceBase
     */
    public async fetchCounterData(context:any,data:any){
    }

    /**
     * 刷新数据
     *
     * @memberof WFExpBarCounterServiceBase
     */
    public async refreshData(){
        if (this['fetchCounterData'] && this['fetchCounterData'] instanceof Function) {
            await this.fetchCounterData(this.context,this.viewparams);
        }
    }

}