/**
 * IBIZBOOKMONTH 部件模型
 *
 * @export
 * @class IBIZBOOKMONTHModel
 */
export default class IBIZBOOKMONTHModel {

	/**
	 * 日历项类型
	 *
	 * @returns {any[]}
	 * @memberof IBIZBOOKMONTHCalendarMode
	 */
	public itemType: string = "";

	/**
	 * 获取数据项集合
	 *
	 * @returns {any[]}
	 * @memberof IBIZBOOKMONTHCalendarMode
	 */
	public getDataItems(): any[] {
     let dataItems: any = [
      {
        name: 'n_ibizbookname_like',
        prop: 'n_ibizbookname_like',
        dataType: 'QUERYPARAM'
      },
      {
        name: 'n_price_gtandeq',
        prop: 'n_price_gtandeq',
        dataType: 'QUERYPARAM'
      },

          // 前端新增修改标识，新增为"0",修改为"1"或未设值
          {
            name: 'srffrontuf',
            prop: 'srffrontuf',
            dataType: 'TEXT',
          },
          {
            name: 'color',
          },
          {
            name: 'textColor',
          },
          {
            name: 'itemType',
          },
          {
            name: 'query',
            prop: 'query',
          },
      ];
      switch(this.itemType){
          case "item1":
              dataItems = [...dataItems,
                  {
                    name: 'ibizbook',
                    prop: 'ibizbookid'
                  },
                  {
                    name: 'title',
                    prop: 'ibizbookname'
                  },
                  {
                    name:'start',
                    prop:'lendouttime'
                  },
                  {
                    name:'end',
                    prop:'returntime'
                  },
              ];
              break;
      }
      return dataItems;
	}

}