import ViewMessageService from '../view-message-service';
/**
 * 向导面板---基础用法视图消息服务对象基类
 * 基于 APP/src/message/%APP_MSG%/%APP_MSG%-message-base.ts.ftl 生成
 * @export
 * @class ViewMsg51MessageServiceBase
 */
export default class ViewMsg51MessageServiceBase extends ViewMessageService {


    /**
     * Creates an instance of  ViewMsg51MessageServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ViewMsg51MessageServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础参数
     * 
     * @memberof ViewMsg51MessageServiceBase
     */
    public initBasicParam(){
        this.id = "4646f728485348f2851f88adc5ec13e1";
        this.name = "向导面板---基础用法";
        this.codename = "ViewMsg51";
        this.title = "";
        this.content = "本示例展示向导面板基础功能：包括业务数据初始化、完成及向导表单的跳转等功能。";
        this.closeMode = 0;
        this.position = "TOP";
        this.type = "error";
        this.isEnableRemove = false;
        this.order = 1;
        this.dynamicMode = "STATIC";
        this.hasMessageTemp = false;
        this.messageType = "TEXT";
    }

    /**
     * 转化消息模板标题和内容
     *      
     * @target {*} target 返回目标数据
     * @param {*} context 应用上下文
     * @param {*} viewparam 视图参数
     * @param {*} item 源数据
     * 
     * @memberof ViewMsg51MessageServiceBase
     */
    public translateMessageTemp(target:any,context:any,viewparam:any,item?:any){
        if(this.hasMessageTemp && Object.is(this.messageType,"HTML")){
            Object.assign(target,{title:``});
            Object.assign(target,{content:``});
        }
        if(this.hasMessageTemp && Object.is(this.messageType,"TEXT")){
            Object.assign(target,{title:""});
            Object.assign(target,{content:""});
        }
    }

}