import ViewMessageService from '../view-message-service';
/**
 * 日历自定义插件视图消息服务对象基类
 *
 * @export
 * @class ViewMsg71MessageServiceBase
 */
export default class ViewMsg71MessageServiceBase extends ViewMessageService {


    /**
     * Creates an instance of  ViewMsg71MessageServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ViewMsg71MessageServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础参数
     * 
     * @memberof ViewMsg71MessageServiceBase
     */
    public initBasicParam(){
        this.id = "002D812F-370C-4169-9114-B27100410950";
        this.name = "日历自定义插件";
        this.codename = "ViewMsg71";
        this.title = "";
        this.content = "本示例展示日历部件自定义插件功能。";
        this.closeMode = 0;
        this.position = "TOP";
        this.type = "error";
        this.isEnableRemove = false;
        this.order = 1;
        this.dynamicMode = "STATIC";
        this.hasMessageTemp = false;
        this.messageType = "TEXT";
    }

    /**
     * 转化消息模板标题和内容
     *      
     * @target {*} target 返回目标数据
     * @param {*} context 应用上下文
     * @param {*} viewparam 视图参数
     * @param {*} item 源数据
     * 
     * @memberof ViewMsg71MessageServiceBase
     */
    public translateMessageTemp(target:any,context:any,viewparam:any,item?:any){
        if(this.hasMessageTemp && Object.is(this.messageType,"HTML")){
            Object.assign(target,{title:``});
            Object.assign(target,{content:``});
        }
        if(this.hasMessageTemp && Object.is(this.messageType,"TEXT")){
            Object.assign(target,{title:""});
            Object.assign(target,{content:""});
        }
    }

}